/*
 * Decompiled with CFR 0.152.
 */
package top.potens.core.exception;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.springframework.beans.BeansException;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import top.potens.core.exception.ApiException;
import top.potens.core.exception.SerializationException;
import top.potens.core.model.ApiResult;
import top.potens.core.util.StringUtil;
import top.potens.log.AppLogger;

@ControllerAdvice
@ResponseBody
public class GlobalExceptionHandler {
    @ExceptionHandler(value={ApiException.class})
    public Object apiExceptionHandler(HttpServletRequest request, ApiException exception) throws Exception {
        return this.getResult(StringUtil.isEmpty((CharSequence)exception.getCode()) ? "0" : exception.getCode(), exception.getMessage());
    }

    private ApiResult getResult(String code, String message) {
        ApiResult result = new ApiResult();
        result.setCode(code);
        result.setMessage(message);
        return result;
    }

    @ExceptionHandler(value={BeansException.class})
    public Object beansException(BeansException exception) throws Exception {
        return this.getResult("510", exception.getMessage());
    }

    @ExceptionHandler(value={SerializationException.class})
    public Object serializationExceptionException(BeansException exception) throws Exception {
        return this.getResult("511", exception.getMessage());
    }

    @ExceptionHandler(value={ServletException.class})
    public Object servletException(ServletException exception) throws Exception {
        return this.getResult("512", exception.getMessage());
    }

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    public Object missingServletRequestParameterException(HttpServletResponse response, HttpServletRequest request, Exception exception) throws Exception {
        MissingServletRequestParameterException c = (MissingServletRequestParameterException)exception;
        StringBuilder message = new StringBuilder();
        message.append(c.getParameterName()).append(" is not present");
        return this.getResult("410", message.toString());
    }

    @ExceptionHandler
    public Object exceptionHandler(HttpServletRequest request, Exception ex) {
        StringBuilder sb = new StringBuilder();
        StackTraceElement[] stacks = ex.getStackTrace();
        if (stacks.length >= 1) {
            sb.append("class: ").append(stacks[1].getClassName()).append("; method: ").append(stacks[1].getMethodName()).append("; line_number: ").append(stacks[1].getLineNumber());
        }
        AppLogger.error((String)sb.toString(), (Throwable)ex, (Object[])new Object[0]);
        return this.getResult("500", ex.getMessage());
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public Object methodArgumentNotValidException(HttpServletResponse response, HttpServletRequest request, Exception exception) throws Exception {
        StringBuilder message;
        block0: {
            MethodArgumentNotValidException c = (MethodArgumentNotValidException)exception;
            List errors = c.getBindingResult().getAllErrors();
            StringBuilder errorMsg = new StringBuilder();
            errors.stream().forEach(x -> errorMsg.append(x.getDefaultMessage()).append(";"));
            message = new StringBuilder();
            Iterator iterator = errors.iterator();
            if (!iterator.hasNext()) break block0;
            ObjectError error = (ObjectError)iterator.next();
            message.append(((FieldError)error).getField() + ":" + ((FieldError)error).getDefaultMessage() + ";");
        }
        return this.getResult("410", message.toString());
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    public Object constraintViolationException(HttpServletResponse response, HttpServletRequest request, Exception exception) throws Exception {
        StringBuilder strBuilder;
        block0: {
            ConstraintViolationException e = (ConstraintViolationException)exception;
            Set violations = e.getConstraintViolations();
            strBuilder = new StringBuilder();
            Iterator iterator = violations.iterator();
            if (!iterator.hasNext()) break block0;
            ConstraintViolation violation = (ConstraintViolation)iterator.next();
            strBuilder.append(violation.getPropertyPath().toString() + ":" + violation.getMessage() + "\n");
        }
        return this.getResult("410", strBuilder.toString());
    }
}

