/*
 * Decompiled with CFR 0.152.
 */
package top.potens.core.plugin;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.ClassUtils;

public class PackageClassesLoader {
    private final Logger logger = LoggerFactory.getLogger(PackageClassesLoader.class);
    private static final String RESOURCE_PATTERN = "/**/*.class";
    private ResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
    private List<String> packagesList = new LinkedList<String>();
    private List<TypeFilter> typeFilters = new LinkedList<TypeFilter>();
    private Set<Class<?>> classSet = new HashSet();

    @SafeVarargs
    public PackageClassesLoader(String[] packagesToScan, Class<? extends Annotation> ... annotationFilter) {
        if (packagesToScan != null) {
            Collections.addAll(this.packagesList, packagesToScan);
        }
        if (annotationFilter != null) {
            for (Class<? extends Annotation> annotation : annotationFilter) {
                this.typeFilters.add((TypeFilter)new AnnotationTypeFilter(annotation, false));
            }
        }
    }

    public Set<Class<?>> getClassSet() throws IOException, ClassNotFoundException {
        this.classSet.clear();
        if (!this.packagesList.isEmpty()) {
            for (String string : this.packagesList) {
                String pattern = "classpath*:" + ClassUtils.convertClassNameToResourcePath((String)string) + RESOURCE_PATTERN;
                Resource[] resources = this.resourcePatternResolver.getResources(pattern);
                CachingMetadataReaderFactory readerFactory = new CachingMetadataReaderFactory((ResourceLoader)this.resourcePatternResolver);
                for (Resource resource : resources) {
                    if (!resource.isReadable()) continue;
                    MetadataReader reader = readerFactory.getMetadataReader(resource);
                    String className = reader.getClassMetadata().getClassName();
                    if (!this.matchesEntityTypeFilter(reader, (MetadataReaderFactory)readerFactory)) continue;
                    this.classSet.add(Class.forName(className));
                }
            }
        }
        if (this.logger.isInfoEnabled()) {
            for (Class clazz : this.classSet) {
                this.logger.info("Found class:{}", (Object)clazz.getName());
            }
        }
        return this.classSet;
    }

    private boolean matchesEntityTypeFilter(MetadataReader reader, MetadataReaderFactory readerFactory) throws IOException {
        if (this.typeFilters.isEmpty()) {
            return true;
        }
        for (TypeFilter filter : this.typeFilters) {
            if (!filter.match(reader, readerFactory)) continue;
            return true;
        }
        return false;
    }
}

