/*
 * Decompiled with CFR 0.152.
 */
package top.potens.core.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.io.IOException;
import java.util.List;
import top.potens.core.exception.SerializationException;
import top.potens.log.AppLogger;

public class JSON {
    private static ObjectMapper objectMapper = new ObjectMapper();

    public static String toJSONString(Object value) {
        try {
            return objectMapper.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new SerializationException(e.getMessage());
        }
    }

    public static String toJSONStringNotEx(Object value) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            AppLogger.error((String)"toJSONStringNotEx error ", (Throwable)e, (Object[])new Object[0]);
            return null;
        }
    }

    @Deprecated
    public static <T> T toObjectNotEx(String str, Class<T> valueType) {
        if (str == null || str.length() == 0 || valueType == null) {
            AppLogger.warn((String)"toObjectNotEx warn params is null str:[{}] valueType:[{}]", (Object[])new Object[]{str, valueType});
            return null;
        }
        try {
            return (T)objectMapper.readValue(str, valueType);
        }
        catch (IOException e) {
            AppLogger.error((String)"toObjectNotEx error ", (Throwable)e, (Object[])new Object[0]);
            return null;
        }
    }

    public static <T> T toBean(String str, Class<T> valueType) {
        if (str == null || str.length() == 0 || valueType == null) {
            AppLogger.warn((String)"toBean warn params is null str:[{}] valueType:[{}]", (Object[])new Object[]{str, valueType});
            return null;
        }
        try {
            return (T)objectMapper.readValue(str, valueType);
        }
        catch (IOException e) {
            throw new SerializationException(e.getMessage());
        }
    }

    public static <T> T toBeanNotEx(String str, Class<T> valueType) {
        if (str == null || str.length() == 0 || valueType == null) {
            AppLogger.warn((String)"toBeanNotEx warn params is null str:[{}] valueType:[{}]", (Object[])new Object[]{str, valueType});
            return null;
        }
        try {
            return (T)objectMapper.readValue(str, valueType);
        }
        catch (IOException e) {
            AppLogger.error((String)"toBeanNotEx error ", (Throwable)e, (Object[])new Object[0]);
            return null;
        }
    }

    public static <T> List<T> toBeanList(String str, Class<T> valueType) {
        if (str == null || str.length() == 0 || valueType == null) {
            AppLogger.warn((String)"toBeanList warn params is null str:[{}] valueType:[{}]", (Object[])new Object[]{str, valueType});
            return null;
        }
        try {
            CollectionType javaType = objectMapper.getTypeFactory().constructCollectionType(List.class, valueType);
            return (List)objectMapper.readValue(str, (JavaType)javaType);
        }
        catch (IOException e) {
            throw new SerializationException(e.getMessage());
        }
    }

    public static <T> List<T> toBeanListNotEx(String str, Class<T> valueType) {
        if (str == null || str.length() == 0 || valueType == null) {
            AppLogger.warn((String)"toBeanListNotEx warn params is null str:[{}] valueType:[{}]", (Object[])new Object[]{str, valueType});
            return null;
        }
        try {
            CollectionType javaType = objectMapper.getTypeFactory().constructCollectionType(List.class, valueType);
            return (List)objectMapper.readValue(str, (JavaType)javaType);
        }
        catch (IOException e) {
            AppLogger.error((String)"toObjectNotEx error ", (Throwable)e, (Object[])new Object[0]);
            return null;
        }
    }

    static {
        objectMapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        objectMapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        objectMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        objectMapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        objectMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
    }
}

