/*
 * Decompiled with CFR 0.152.
 */
package top.potens.core.util;

import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import java.util.List;
import java.util.WeakHashMap;
import net.sf.cglib.beans.BeanCopier;

public class BeanCopierUtil {
    private static WeakHashMap<String, BeanCopier> container = new WeakHashMap();
    private static Interner interner = Interners.newWeakInterner();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BeanCopier getBeanCopier(Class source, Class target) {
        String key = source.getName() + "_" + target.getName();
        BeanCopier copier = container.get(key);
        if (copier != null) {
            return copier;
        }
        Object object = interner.intern((Object)key);
        synchronized (object) {
            copier = container.get(key);
            if (copier != null) {
                return copier;
            }
            BeanCopier beanCopier = BeanCopier.create((Class)source, (Class)target, (boolean)false);
            container.put(key, beanCopier);
            return beanCopier;
        }
    }

    public static <T> T convert(Object source, Class<T> targetClass) {
        if (source == null) {
            return null;
        }
        BeanCopier beanCopier = BeanCopierUtil.getBeanCopier(source.getClass(), targetClass);
        try {
            T target = targetClass.newInstance();
            beanCopier.copy(source, target, null);
            return target;
        }
        catch (Exception e) {
            throw new RuntimeException("\u5bf9\u8c61\u62f7\u8d1d\u5931\u8d25" + source + "_" + targetClass);
        }
    }

    public static void convert(Object source, Object target) {
        if (source == null) {
            return;
        }
        BeanCopier beanCopier = BeanCopierUtil.getBeanCopier(source.getClass(), target.getClass());
        try {
            beanCopier.copy(source, target, null);
        }
        catch (Exception e) {
            throw new RuntimeException("\u5bf9\u8c61\u62f7\u8d1d\u5931\u8d25" + source + "_" + target.getClass());
        }
    }

    public static <E> List<E> convert(List source, Class<E> targetClass) {
        if (source == null) {
            return null;
        }
        try {
            if (source.isEmpty()) {
                return (List)source.getClass().newInstance();
            }
            List result = (List)source.getClass().newInstance();
            for (Object each : source) {
                result.add(BeanCopierUtil.convert(each, targetClass));
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException("\u5bf9\u8c61\u62f7\u8d1d\u5931\u8d25" + source + "_" + targetClass);
        }
    }

    public static <E> void convert(List source, List<E> target, Class<E> targetClass) {
        if (source == null) {
            return;
        }
        try {
            if (source.isEmpty()) {
                return;
            }
            for (Object each : source) {
                target.add(BeanCopierUtil.convert(each, targetClass));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u5bf9\u8c61\u62f7\u8d1d\u5931\u8d25" + source + "_" + targetClass);
        }
    }
}

