/*
 * Decompiled with CFR 0.152.
 */
package top.potens.core.util;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import top.potens.core.enums.EncryptAlgorithmEnum;
import top.potens.core.util.StringUtil;

public class EncryptUtil {
    public static String md5(String inputText) {
        return EncryptUtil.encrypt("", inputText, EncryptAlgorithmEnum.MD5);
    }

    public static String md5(String salt, String inputText) {
        return EncryptUtil.encrypt(salt, inputText, EncryptAlgorithmEnum.MD5);
    }

    public static String sha1(String inputText) {
        return EncryptUtil.encrypt("", inputText, EncryptAlgorithmEnum.SHA1);
    }

    public static String sha1(String salt, String inputText) {
        return EncryptUtil.encrypt(salt, inputText, EncryptAlgorithmEnum.SHA1);
    }

    public static String encrypt(String inputText, EncryptAlgorithmEnum algorithmEnum) {
        return EncryptUtil.encrypt("", inputText, algorithmEnum);
    }

    public static String encrypt(String salt, String inputText, EncryptAlgorithmEnum algorithmEnum) {
        if (StringUtil.isBlank((CharSequence)salt)) {
            salt = "";
        }
        if (inputText == null || "".equals(inputText.trim())) {
            throw new IllegalArgumentException("\u8bf7\u8f93\u5165\u8981\u52a0\u5bc6\u7684\u5185\u5bb9");
        }
        try {
            MessageDigest md = MessageDigest.getInstance(algorithmEnum.getAlgorithm());
            md.update((salt + inputText).getBytes());
            return new BigInteger(1, md.digest()).toString(16);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("\u52a0\u5bc6\u7b97\u6cd5\u672a\u627e\u5230");
        }
    }
}

