/*
 * Decompiled with CFR 0.152.
 */
package top.potens.core.aop;

import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import top.potens.core.enums.CommonExceptionCodeEnums;
import top.potens.core.exception.ApiException;
import top.potens.core.serialization.JSON;
import top.potens.log.AppLogger;
import top.potens.log.HttpContext;

@Aspect
@Component
@Order(value=1001)
public class ControllerVisitAspect {
    @Pointcut(value="@within(org.springframework.stereotype.Controller) || @within(org.springframework.web.bind.annotation.RestController)")
    public void pointcut() {
    }

    @Around(value="pointcut()")
    public Object handle(ProceedingJoinPoint joinPoint) throws Throwable {
        boolean isJson;
        HttpServletRequest request = HttpContext.getRequest();
        if (request == null) {
            throw new ApiException(CommonExceptionCodeEnums.REQUEST_IS_NULL);
        }
        String uri = request.getRequestURI().replace(request.getContextPath(), "");
        AppLogger.info((String)"request.getContentType() {}", (Object[])new Object[]{request.getContentType()});
        boolean bl = isJson = "application/json".equals(request.getContentType()) || "application/x-www-form-urlencoded".equals(request.getContentType());
        if (isJson) {
            AppLogger.info((String)"controller-start-request uri:[{}] methodName:[{}] param:[{}]", (Object[])new Object[]{uri, joinPoint.getSignature().getName(), JSON.toJSONStringNotEx(joinPoint.getArgs())});
        } else {
            AppLogger.info((String)"controller-start-request uri:[{}] methodName:[{}]", (Object[])new Object[]{uri, joinPoint.getSignature().getName()});
        }
        Object result = joinPoint.proceed();
        AppLogger.info((String)"controller-end-request uri:[{}] methodName:[{}] result:[{}]", (Object[])new Object[]{uri, joinPoint.getSignature().getName(), JSON.toJSONStringNotEx(result)});
        return result;
    }

    @AfterThrowing(pointcut="pointcut()", throwing="ex")
    public void doAfterEx(JoinPoint joinPoint, Throwable ex) {
        HttpServletRequest request = HttpContext.getRequest();
        if (request == null) {
            throw new ApiException(CommonExceptionCodeEnums.REQUEST_IS_NULL);
        }
        String uri = request.getRequestURI().replace(request.getContextPath(), "");
        if (ex instanceof ApiException) {
            AppLogger.warn((String)"error uri:[{}] methodName:[{}]", (Throwable)ex, (Object[])new Object[]{uri, joinPoint.getSignature().getName()});
        } else {
            AppLogger.error((String)"error uri:[{}] methodName:[{}]", (Throwable)ex, (Object[])new Object[]{uri, joinPoint.getSignature().getName()});
        }
    }
}

