/*
 * Decompiled with CFR 0.152.
 */
package top.potens.core.response;

import java.lang.reflect.Field;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.helpers.MessageFormatter;
import top.potens.core.annotation.ResultMessage;
import top.potens.core.plugin.PackageClassesLoader;
import top.potens.log.AppLogger;

public class ResultCodeInit {
    private static final ConcurrentHashMap<String, String> resultCodeMsgMap = new ConcurrentHashMap();

    public static void addResultCodeDefinitionClass(Class<?> c) {
        try {
            Field[] fields;
            for (Field field : fields = c.getDeclaredFields()) {
                String resultMsg;
                ResultMessage annotation;
                field.setAccessible(true);
                String resultCode = String.valueOf(field.get(null));
                if (resultCodeMsgMap.containsKey(resultCode)) {
                    AppLogger.error((String)("Result code definitions conflict! resultCode\uff1a" + resultCode), (Object[])new Object[0]);
                    System.exit(0);
                }
                if (null == (annotation = field.getAnnotation(ResultMessage.class)) || null == (resultMsg = annotation.value()) || "".equals(resultMsg.trim())) continue;
                resultCodeMsgMap.put(resultCode, resultMsg);
            }
        }
        catch (Exception e) {
            AppLogger.error((String)"Fail to add result code info!", (Throwable)e, (Object[])new Object[0]);
        }
    }

    public static void addResultCodeDefinitionClassByPackage(String ... packageName) {
        if (packageName == null || packageName.length <= 0) {
            return;
        }
        try {
            PackageClassesLoader packageClassesLoader = new PackageClassesLoader(packageName, new Class[0]);
            Set<Class<?>> set = packageClassesLoader.getClassSet();
            for (Class<?> c : set) {
                ResultCodeInit.addResultCodeDefinitionClass(c);
            }
        }
        catch (Exception e) {
            AppLogger.error((String)"addResultCodeDefinitionClassByPackage error", (Throwable)e, (Object[])new Object[0]);
            System.exit(0);
        }
    }

    public static String getResultMsg(String resultCode, Object ... args) {
        String message = resultCodeMsgMap.getOrDefault(resultCode, "");
        if (StringUtils.isNotBlank((CharSequence)message) && args != null && args.length > 0) {
            message = MessageFormatter.format((String)message, (Object)args).getMessage();
        }
        return message;
    }
}

