/*
 * Decompiled with CFR 0.152.
 */
package top.potens.redis.config;

import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.redisson.config.SingleServerConfig;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class RedissonConfiguration {
    @Value(value="${fx.redis.redisson.url}")
    private String url;
    @Value(value="${fx.redis.redisson.password}")
    private String password;
    @Value(value="${fx.redis.redisson.database}")
    private Integer database;

    @Bean
    public RedissonClient getRedisson() {
        if (this.password == null || this.password.length() == 0) {
            this.password = null;
        }
        Config config = new Config();
        ((SingleServerConfig)config.useSingleServer().setAddress(this.url).setPassword(this.password)).setDatabase(this.database.intValue()).setConnectionPoolSize(10).setConnectionMinimumIdleSize(4).setSubscriptionConnectionPoolSize(5).setSubscriptionConnectionMinimumIdleSize(2);
        return Redisson.create((Config)config);
    }
}

