/*
 * Decompiled with CFR 0.152.
 */
package top.potens.redis.aop;

import java.util.concurrent.TimeUnit;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.redisson.RedissonMultiLock;
import org.redisson.RedissonRedLock;
import org.redisson.api.RLock;
import org.redisson.api.RReadWriteLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ParserContext;
import org.springframework.expression.common.TemplateParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.stereotype.Component;
import top.potens.redis.annotation.Lock;
import top.potens.redis.enums.LockModel;
import top.potens.redis.exception.LockException;

@Aspect
@Component
public class LockAop {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${fx.config.redisson.default.attempt.timeout:100}")
    private Integer attemptTimeout;
    @Value(value="${fx.config.redisson.default.watch.timeout:120}")
    private Integer watchTimeout;
    @Value(value="${spring.application.name}")
    private String springApplicationName;
    @Autowired
    private RedissonClient redisson;

    @Pointcut(value="@annotation(lock)")
    public void controllerAspect(Lock lock) {
    }

    private String getValueBySpel(String key, String[] parameterNames, Object[] values, boolean projectPrefix) {
        if (projectPrefix) {
            key = this.springApplicationName + ":" + key;
        }
        if (!key.contains("#")) {
            return key;
        }
        SpelExpressionParser parser = new SpelExpressionParser();
        StandardEvaluationContext context = new StandardEvaluationContext();
        for (int i = 0; i < parameterNames.length; ++i) {
            context.setVariable(parameterNames[i], values[i]);
        }
        String value = null;
        try {
            Expression expression = parser.parseExpression(key, (ParserContext)new TemplateParserContext());
            value = (String)expression.getValue((EvaluationContext)context, String.class);
        }
        catch (Exception e) {
            throw new LockException("\u89e3\u6790\u5931\u8d25");
        }
        if (value == null || value.length() == 0) {
            throw new LockException("lock value is blank");
        }
        this.logger.info("spel\u8868\u8fbe\u5f0fkey={},value={}", (Object)key, (Object)value);
        return value;
    }

    @Around(value="controllerAspect(lock)", argNames="proceedingJoinPoint,lock")
    public Object aroundAdvice(ProceedingJoinPoint proceedingJoinPoint, Lock lock) throws Throwable {
        RReadWriteLock rReadWriteLock;
        RLock[] locks;
        LockModel lockModel;
        long lockWatchTimeout;
        String[] keys = lock.keys();
        if (keys.length == 0) {
            throw new LockException("keys\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String[] parameterNames = new LocalVariableTableParameterNameDiscoverer().getParameterNames(((MethodSignature)proceedingJoinPoint.getSignature()).getMethod());
        Object[] args = proceedingJoinPoint.getArgs();
        long attemptTimeout = lock.attemptTimeout();
        if (attemptTimeout == 0L) {
            attemptTimeout = this.attemptTimeout.intValue();
        }
        if ((lockWatchTimeout = lock.lockWatchTimeout()) == 0L) {
            lockWatchTimeout = this.watchTimeout.intValue();
        }
        if ((lockModel = lock.lockModel()).equals((Object)LockModel.AUTO)) {
            lockModel = keys.length > 1 ? LockModel.MULTIPLE : LockModel.FAIR;
        }
        if (!lockModel.equals((Object)LockModel.MULTIPLE) && !lockModel.equals((Object)LockModel.REDLOCK) && keys.length > 1) {
            throw new LockException("\u53c2\u6570\u6709\u591a\u4e2a,\u9501\u6a21\u5f0f\u4e3a->" + lockModel.name() + ".\u65e0\u6cd5\u9501\u5b9a");
        }
        this.logger.info("model:[{}] attemptTimeout:[{}] lockWatchTimeout:[{}] timeUnit:[{}]", new Object[]{lockModel.name(), attemptTimeout, lockWatchTimeout, lock.timeUnit()});
        boolean res = false;
        RLock rLock = null;
        if (LockModel.FAIR.equals((Object)lockModel)) {
            rLock = this.redisson.getFairLock(this.getValueBySpel(keys[0], parameterNames, args, lock.projectPrefix()));
        } else if (LockModel.REDLOCK.equals((Object)lockModel)) {
            locks = new RLock[keys.length];
            int index = 0;
            for (String key : keys) {
                locks[index++] = this.redisson.getLock(this.getValueBySpel(key, parameterNames, args, lock.projectPrefix()));
            }
            rLock = new RedissonRedLock(locks);
        } else if (LockModel.MULTIPLE.equals((Object)lockModel)) {
            locks = new RLock[keys.length];
            int index = 0;
            for (String key : keys) {
                locks[index++] = this.redisson.getLock(this.getValueBySpel(key, parameterNames, args, lock.projectPrefix()));
            }
            rLock = new RedissonMultiLock(locks);
        } else if (LockModel.REENTRANT.equals((Object)lockModel)) {
            rLock = this.redisson.getLock(this.getValueBySpel(keys[0], parameterNames, args, lock.projectPrefix()));
        } else if (LockModel.READ.equals((Object)lockModel)) {
            rReadWriteLock = this.redisson.getReadWriteLock(this.getValueBySpel(keys[0], parameterNames, args, lock.projectPrefix()));
            rLock = rReadWriteLock.readLock();
        } else if (LockModel.WRITE.equals((Object)lockModel)) {
            rReadWriteLock = this.redisson.getReadWriteLock(this.getValueBySpel(keys[0], parameterNames, args, lock.projectPrefix()));
            rLock = rReadWriteLock.writeLock();
        }
        if (rLock != null) {
            try {
                if (attemptTimeout == -1L) {
                    res = true;
                    rLock.lock(lockWatchTimeout, TimeUnit.MILLISECONDS);
                } else {
                    res = rLock.tryLock(attemptTimeout, lockWatchTimeout, lock.timeUnit());
                }
                if (res) {
                    Object object = proceedingJoinPoint.proceed();
                    return object;
                }
                throw new LockException("\u83b7\u53d6\u9501\u5931\u8d25");
            }
            finally {
                if (res) {
                    rLock.unlock();
                }
            }
        }
        throw new LockException("\u83b7\u53d6\u9501\u5931\u8d25");
    }
}

