/*
 * Decompiled with CFR 0.152.
 */
package top.qingxing.hoop.aop.interceptor;

import com.alibaba.fastjson.JSON;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import top.qingxing.hoop.entity.MenusUrl;
import top.qingxing.hoop.exceptionHandler.AccessDeniedException;
import top.qingxing.hoop.exceptionHandler.ExceptionEnum;
import top.qingxing.hoop.exceptionHandler.LoginNotException;
import top.qingxing.hoop.service.EncryotentService;
import top.qingxing.hoop.service.JudgeAuthorityService;
import top.qingxing.hoop.service.LoginStateService;

@Aspect
public class HoopLjAop {
    @Autowired
    EncryotentService encryotentService;
    @Autowired
    LoginStateService loginStateService;
    @Autowired
    JudgeAuthorityService judgeAuthorityService;

    @Pointcut(value="@within(top.qingxing.hoop.aop.interceptor.Hoop) || @annotation(top.qingxing.hoop.aop.interceptor.Hoop)")
    public void lj() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="lj()")
    public Object around(ProceedingJoinPoint pjp) throws Throwable {
        int status = 200;
        Object obj = null;
        try {
            Map<String, String> ares;
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            String token = null;
            Cookie[] cookies = request.getCookies();
            if (cookies != null) {
                for (Cookie cookie : cookies) {
                    if (!cookie.getName().equals("uhooptoken")) continue;
                    token = cookie.getValue();
                    break;
                }
            }
            if ((ares = this.encryotentService.verifyToken(token)) != null) {
                List<MenusUrl> menusUrls = this.judgeAuthorityService.getmenurights(Integer.parseInt(ares.get("id")));
                String userurl = JSON.toJSON(menusUrls).toString();
                if (!userurl.contains("{\"url\":\"" + request.getRequestURI() + "\"}")) {
                    status = 403;
                }
                obj = pjp.proceed();
            }
            status = 401;
            return status;
        }
        catch (Throwable e) {
            e.printStackTrace();
            Object var5_7 = null;
            return var5_7;
        }
        finally {
            if (status == 403) {
                throw new AccessDeniedException(ExceptionEnum.ACCESS_DENIED);
            }
            if (status == 401) {
                throw new LoginNotException(ExceptionEnum.LOGIN_NOT);
            }
            return obj;
        }
    }
}

