/*
 * Decompiled with CFR 0.152.
 */
package top.qingxing.hoop.entity;

import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import top.qingxing.hoop.encryot.md5.Md5Utils;
import top.qingxing.hoop.encryot.pbkdf2.PdkdfUtils;

public enum EncryptEnum {
    PBKDF2("PBKDF2"){

        @Override
        public boolean verify(String password, String salt, String key) throws InvalidKeySpecException, NoSuchAlgorithmException {
            return new PdkdfUtils().verify(password, salt, key);
        }

        @Override
        public String encrypt(String password, String salt) throws InvalidKeySpecException, NoSuchAlgorithmException {
            return new PdkdfUtils().getEncryot(password, salt);
        }
    }
    ,
    MD5("MD5"){

        @Override
        public boolean verify(String password, String salt, String key) throws InvalidKeySpecException, NoSuchAlgorithmException {
            return new Md5Utils().verify(password, salt, key);
        }

        @Override
        public String encrypt(String password, String salt) throws InvalidKeySpecException, NoSuchAlgorithmException {
            return new Md5Utils().getEncryot(password, salt);
        }
    };

    private String value;

    public abstract String encrypt(String var1, String var2) throws InvalidKeySpecException, NoSuchAlgorithmException;

    public abstract boolean verify(String var1, String var2, String var3) throws InvalidKeySpecException, NoSuchAlgorithmException;

    public String getValue() {
        return this.value;
    }

    private EncryptEnum(String value) {
        this.value = value;
    }
}

