/*
 * Decompiled with CFR 0.152.
 */
package top.qingxing.hoop.config;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import top.qingxing.hoop.entity.SettingEnum;

@Configuration
@ConfigurationProperties(prefix="hoop")
public class SettingConfig {
    private final Pbkdf pbkdf = new Pbkdf();
    private final Token token = new Token();
    private String encrypt = "";

    public Pbkdf getPbkdf() {
        return this.pbkdf;
    }

    public Token getToken() {
        return this.token;
    }

    public String getEncrypt() {
        return this.encrypt;
    }

    public void setEncrypt(String encrypt) {
        this.encrypt = encrypt;
    }

    @Bean
    public void hoopSetting() {
        SettingEnum.ENCRYPT.setValue(this.getEncrypt());
        SettingEnum.SALESIZE.setValue(this.pbkdf.getSalesize());
        SettingEnum.HASHSIZE.setValue(this.pbkdf.getHashsize());
        SettingEnum.ITERATIONS.setValue(this.pbkdf.getIterations());
        SettingEnum.COOKIENAME.setValue(this.token.getCookiename());
        SettingEnum.SECRET.setValue(this.token.getSecret());
        SettingEnum.ISSUER.setValue(this.token.getIssuer());
        SettingEnum.EXTIME.setValue(this.token.getExtime());
        SettingEnum.DOMAIN.setValue(this.token.getDomain());
    }

    public static class Token {
        private String cookiename = "uhooptoken";
        private String secret = "";
        private String issuer = "";
        private int extime = 0;
        private String domain = "";

        public String getCookiename() {
            return this.cookiename;
        }

        public void setCookiename(String cookiename) {
            this.cookiename = cookiename;
        }

        public String getSecret() {
            return this.secret;
        }

        public void setSecret(String secret) {
            this.secret = secret;
        }

        public String getIssuer() {
            return this.issuer;
        }

        public void setIssuer(String issuer) {
            this.issuer = issuer;
        }

        public int getExtime() {
            return this.extime;
        }

        public void setExtime(int extime) {
            this.extime = extime;
        }

        public String getDomain() {
            return this.domain;
        }

        public void setDomain(String domain) {
            this.domain = domain;
        }
    }

    public static class Pbkdf {
        private int salesize = 0;
        private int hashsize = 0;
        private int iterations = 0;

        public int getSalesize() {
            return this.salesize;
        }

        public void setSalesize(int salesize) {
            this.salesize = salesize;
        }

        public int getHashsize() {
            return this.hashsize;
        }

        public void setHashsize(int hashsize) {
            this.hashsize = hashsize;
        }

        public int getIterations() {
            return this.iterations;
        }

        public void setIterations(int iterations) {
            this.iterations = iterations;
        }
    }
}

