/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.crypto;

import java.util.Arrays;
import top.redscorpion.crypto.CipherMode;

public interface Cipher {
    public String getAlgorithmName();

    public int getBlockSize();

    public void init(CipherMode var1, Parameters var2);

    public int getOutputSize(int var1);

    public int process(byte[] var1, int var2, int var3, byte[] var4, int var5);

    public int doFinal(byte[] var1, int var2);

    default public byte[] processFinal(byte[] in) {
        byte[] buf = new byte[this.getOutputSize(in.length)];
        int len = this.process(in, 0, in.length, buf, 0);
        if ((len += this.doFinal(buf, len)) == buf.length) {
            return buf;
        }
        return Arrays.copyOfRange(buf, 0, len);
    }

    public static interface Parameters {
    }
}

