/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.crypto.symmetric;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;
import top.redscorpion.core.io.IORuntimeException;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.lang.Opt;
import top.redscorpion.core.lang.wrapper.SimpleWrapper;
import top.redscorpion.core.util.RsArray;
import top.redscorpion.core.util.RsIo;
import top.redscorpion.core.util.RsRandom;
import top.redscorpion.core.util.RsString;
import top.redscorpion.crypto.Cipher;
import top.redscorpion.crypto.CipherMode;
import top.redscorpion.crypto.CryptoException;
import top.redscorpion.crypto.JceCipher;
import top.redscorpion.crypto.Padding;
import top.redscorpion.crypto.RsKey;
import top.redscorpion.crypto.openssl.OpenSSLSaltParser;
import top.redscorpion.crypto.openssl.SaltMagic;
import top.redscorpion.crypto.symmetric.SymmetricAlgorithm;
import top.redscorpion.crypto.symmetric.SymmetricDecryptor;
import top.redscorpion.crypto.symmetric.SymmetricEncryptor;

public class SymmetricCrypto
implements SymmetricEncryptor,
SymmetricDecryptor,
Serializable {
    private static final long serialVersionUID = 1L;
    private JceCipher cipher;
    private AlgorithmParameterSpec algorithmParameterSpec;
    private SecureRandom random;
    private SecretKey secretKey;
    private boolean isZeroPadding;
    private final Lock lock = new ReentrantLock();

    public SymmetricCrypto(SymmetricAlgorithm algorithm, byte[] key) {
        this(algorithm.getValue(), key);
    }

    public SymmetricCrypto(String algorithm, byte[] key) {
        this(algorithm, RsKey.generateKey(algorithm, key));
    }

    public SymmetricCrypto(String algorithm, SecretKey key) {
        this(algorithm, key, null);
    }

    public SymmetricCrypto(String algorithm, SecretKey key, AlgorithmParameterSpec paramsSpec) {
        this.init(algorithm, key);
        this.initParams(algorithm, paramsSpec);
    }

    public SymmetricCrypto init(String algorithm, SecretKey key) {
        Assert.notBlank((CharSequence)algorithm, (String)"'algorithm' must be not blank !", (Object[])new Object[0]);
        this.secretKey = key;
        if (algorithm.contains(Padding.ZeroPadding.name())) {
            algorithm = RsString.replace((CharSequence)algorithm, (CharSequence)Padding.ZeroPadding.name(), (CharSequence)Padding.NoPadding.name());
            this.isZeroPadding = true;
        }
        this.cipher = new JceCipher(algorithm);
        return this;
    }

    public Cipher getCipher() {
        return (Cipher)this.cipher.getRaw();
    }

    public SymmetricCrypto setAlgorithmParameterSpec(AlgorithmParameterSpec algorithmParameterSpec) {
        this.algorithmParameterSpec = algorithmParameterSpec;
        return this;
    }

    @Override
    public byte[] encrypt(byte[] data) {
        return this.encrypt(data, null);
    }

    public byte[] encrypt(byte[] data, byte[] salt) {
        byte[] result;
        this.lock.lock();
        try {
            JceCipher cipher = this.initMode(CipherMode.ENCRYPT, salt);
            result = cipher.processFinal(this.paddingDataWithZero(data, cipher.getBlockSize()));
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        finally {
            this.lock.unlock();
        }
        return SaltMagic.addMagic(result, salt);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void encrypt(InputStream data, OutputStream out, boolean isClose) throws IORuntimeException {
        CipherOutputStream cipherOutputStream = null;
        this.lock.lock();
        try {
            int remainLength;
            int blockSize;
            JceCipher cipher = this.initMode(CipherMode.ENCRYPT, null);
            cipherOutputStream = new CipherOutputStream(out, (Cipher)cipher.getRaw());
            long length = RsIo.copy((InputStream)data, (OutputStream)cipherOutputStream);
            if (this.isZeroPadding && (blockSize = cipher.getBlockSize()) > 0 && (remainLength = (int)(length % (long)blockSize)) > 0) {
                cipherOutputStream.write(new byte[blockSize - remainLength]);
                cipherOutputStream.flush();
            }
            this.lock.unlock();
        }
        catch (IORuntimeException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new CryptoException(e2);
                }
            }
            catch (Throwable throwable) {
                this.lock.unlock();
                RsIo.closeQuietly((AutoCloseable[])new AutoCloseable[]{cipherOutputStream});
                if (!isClose) throw throwable;
                RsIo.closeQuietly((AutoCloseable[])new AutoCloseable[]{data});
                throw throwable;
            }
        }
        RsIo.closeQuietly((AutoCloseable[])new AutoCloseable[]{cipherOutputStream});
        if (!isClose) return;
        RsIo.closeQuietly((AutoCloseable[])new AutoCloseable[]{data});
    }

    @Override
    public byte[] decrypt(byte[] bytes) {
        byte[] decryptData;
        int blockSize;
        this.lock.lock();
        try {
            byte[] salt = SaltMagic.getSalt(bytes);
            JceCipher cipher = this.initMode(CipherMode.DECRYPT, salt);
            blockSize = cipher.getBlockSize();
            decryptData = cipher.processFinal(SaltMagic.getData(bytes));
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        finally {
            this.lock.unlock();
        }
        return this.removePadding(decryptData, blockSize);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void decrypt(InputStream data, OutputStream out, boolean isClose) throws IORuntimeException {
        CipherInputStream cipherInputStream;
        block7: {
            int blockSize;
            cipherInputStream = null;
            this.lock.lock();
            JceCipher cipher = this.initMode(CipherMode.DECRYPT, null);
            cipherInputStream = new CipherInputStream(data, (Cipher)cipher.getRaw());
            if (!this.isZeroPadding || (blockSize = cipher.getBlockSize()) <= 0) break block7;
            SymmetricCrypto.copyForZeroPadding(cipherInputStream, out, blockSize);
            this.lock.unlock();
            RsIo.closeQuietly((AutoCloseable[])new AutoCloseable[]{cipherInputStream});
            if (!isClose) return;
            RsIo.closeQuietly((AutoCloseable[])new AutoCloseable[]{data});
            return;
        }
        try {
            RsIo.copy((InputStream)cipherInputStream, (OutputStream)out);
            this.lock.unlock();
        }
        catch (IOException e) {
            try {
                throw new IORuntimeException((Throwable)e);
                catch (IORuntimeException e2) {
                    throw e2;
                }
                catch (Exception e3) {
                    throw new CryptoException(e3);
                }
            }
            catch (Throwable throwable) {
                this.lock.unlock();
                RsIo.closeQuietly((AutoCloseable[])new AutoCloseable[]{cipherInputStream});
                if (!isClose) throw throwable;
                RsIo.closeQuietly((AutoCloseable[])new AutoCloseable[]{data});
                throw throwable;
            }
        }
        RsIo.closeQuietly((AutoCloseable[])new AutoCloseable[]{cipherInputStream});
        if (!isClose) return;
        RsIo.closeQuietly((AutoCloseable[])new AutoCloseable[]{data});
        return;
    }

    private SymmetricCrypto initParams(String algorithm, AlgorithmParameterSpec paramsSpec) {
        if (null == paramsSpec) {
            byte[] iv = (byte[])Opt.ofNullable((Object)this.cipher).map(SimpleWrapper::getRaw).map(Cipher::getIV).get();
            if (RsString.startWith((CharSequence)algorithm, (CharSequence)"PBE", (boolean)true)) {
                if (null == iv) {
                    iv = RsRandom.randomBytes((int)8);
                }
                paramsSpec = new PBEParameterSpec(iv, 100);
            } else if (RsString.startWith((CharSequence)algorithm, (CharSequence)"AES", (boolean)true) && null != iv) {
                paramsSpec = new IvParameterSpec(iv);
            }
        }
        return this.setAlgorithmParameterSpec(paramsSpec);
    }

    private JceCipher initMode(CipherMode mode, byte[] salt) {
        SecretKey secretKey = this.secretKey;
        if (null != salt) {
            String algorithm = this.getCipher().getAlgorithm();
            byte[][] keyAndIV = OpenSSLSaltParser.ofMd5(32, algorithm).getKeyAndIv(secretKey.getEncoded(), salt);
            secretKey = RsKey.generateKey(algorithm, keyAndIV[0]);
            if (RsArray.isNotEmpty((byte[])keyAndIV[1])) {
                this.setAlgorithmParameterSpec(new IvParameterSpec(keyAndIV[1]));
            }
        }
        JceCipher cipher = this.cipher;
        cipher.init(mode, (Cipher.Parameters)new JceCipher.JceParameters(secretKey, this.algorithmParameterSpec, this.random));
        return cipher;
    }

    private byte[] paddingDataWithZero(byte[] data, int blockSize) {
        int length;
        int remainLength;
        if (this.isZeroPadding && (remainLength = (length = data.length) % blockSize) > 0) {
            return RsArray.resize((byte[])data, (int)(length + blockSize - remainLength));
        }
        return data;
    }

    private byte[] removePadding(byte[] data, int blockSize) {
        int length;
        int remainLength;
        if (this.isZeroPadding && blockSize > 0 && (remainLength = (length = data.length) % blockSize) == 0) {
            int i;
            for (i = length - 1; i >= 0 && 0 == data[i]; --i) {
            }
            return RsArray.resize((byte[])data, (int)(i + 1));
        }
        return data;
    }

    private static void copyForZeroPadding(CipherInputStream in, OutputStream out, int blockSize) throws IOException {
        int i;
        int readSize;
        int n = 1;
        if (8192 > blockSize) {
            n = Math.max(n, 8192 / blockSize);
        }
        int bufSize = blockSize * n;
        byte[] preBuffer = new byte[bufSize];
        byte[] buffer = new byte[bufSize];
        boolean isFirst = true;
        int preReadSize = 0;
        while ((readSize = in.read(buffer)) != -1) {
            if (isFirst) {
                isFirst = false;
            } else {
                out.write(preBuffer, 0, preReadSize);
            }
            RsArray.copy((Object)buffer, (Object)preBuffer, (int)readSize);
            preReadSize = readSize;
        }
        for (i = preReadSize - 1; i >= 0 && 0 == preBuffer[i]; --i) {
        }
        out.write(preBuffer, 0, i + 1);
        out.flush();
    }
}

