/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.crypto;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.util.Objects;
import javax.crypto.Cipher;
import top.redscorpion.core.codec.binary.Base64;
import top.redscorpion.core.codec.binary.Hex;
import top.redscorpion.core.util.RsArray;
import top.redscorpion.core.util.RsSystem;
import top.redscorpion.core.util.RsValidator;
import top.redscorpion.crypto.CryptoException;
import top.redscorpion.crypto.Mode;
import top.redscorpion.crypto.Padding;
import top.redscorpion.crypto.provider.GlobalProviderFactory;
import top.redscorpion.crypto.symmetric.Aes;

public class RsSecure {
    public static String RS_CRYPTO_DECODE_HEX = "redscorpion.crypto.decodeHex";

    public static Aes aes(byte[] key) {
        return new Aes(key);
    }

    public static void addProvider(Provider provider) {
        if (RsArray.contains((Object[])Security.getProviders(), (Object)provider)) {
            return;
        }
        Security.insertProviderAt(provider, 0);
    }

    public static byte[] decode(String key) {
        if (Objects.isNull(key)) {
            return null;
        }
        boolean decodeHex = RsSystem.getBoolean((String)RS_CRYPTO_DECODE_HEX, (boolean)true);
        if (decodeHex && RsValidator.isHex((CharSequence)key)) {
            return Hex.decode((CharSequence)key);
        }
        if (Base64.isTypeBase64((CharSequence)key)) {
            return Base64.decode((CharSequence)key);
        }
        throw new IllegalArgumentException("Value is not hex or base64!");
    }

    public static Cipher createCipher(String algorithm) {
        Cipher cipher;
        Provider provider = GlobalProviderFactory.getProvider();
        try {
            cipher = null == provider ? Cipher.getInstance(algorithm) : Cipher.getInstance(algorithm, provider);
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        return cipher;
    }

    public static MessageDigest createJdkMessageDigest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(e);
        }
    }

    public static Aes aes(String key) {
        return new Aes(key.getBytes());
    }

    public static Aes aes(Mode mode, Padding padding, byte[] key, byte[] iv) {
        return new Aes(mode, padding, key, iv);
    }

    public static Aes aes(Mode mode, String padding, byte[] key, byte[] iv) {
        return new Aes(mode.name(), padding, key, iv);
    }

    public static Aes aes(Mode mode, String padding, String key, String iv) {
        return new Aes(mode.name(), padding, key.getBytes(), iv.getBytes());
    }

    public static Aes aes(Mode mode, byte[] key, byte[] iv) {
        return new Aes(mode.name(), Padding.PKCS5Padding.name(), key, iv);
    }

    public static Aes aes(Mode mode, String key, String iv) {
        return new Aes(mode.name(), Padding.PKCS5Padding.name(), key.getBytes(), iv.getBytes());
    }
}

