/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.crypto;

import java.security.InvalidKeyException;
import java.security.spec.KeySpec;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import top.redscorpion.core.util.RsRandom;
import top.redscorpion.crypto.CryptoException;

public class RsSpec {
    public static KeySpec createKeySpec(String algorithm, byte[] key) {
        try {
            if (algorithm.startsWith("DESede")) {
                if (null == key) {
                    key = RsRandom.randomBytes((int)24);
                }
                return new DESedeKeySpec(key);
            }
            if (algorithm.startsWith("DES")) {
                if (null == key) {
                    key = RsRandom.randomBytes((int)8);
                }
                return new DESKeySpec(key);
            }
        }
        catch (InvalidKeyException e) {
            throw new CryptoException(e);
        }
        return new SecretKeySpec(key, algorithm);
    }

    public static PBEKeySpec createPBEKeySpec(char[] password) {
        if (null == password) {
            password = RsRandom.randomStringLower((int)32).toCharArray();
        }
        return new PBEKeySpec(password);
    }
}

