/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.extra.servlet;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import top.redscorpion.core.exceptions.RsException;
import top.redscorpion.core.net.NetUtil;
import top.redscorpion.core.util.RsArray;
import top.redscorpion.core.util.RsFile;
import top.redscorpion.core.util.RsString;

public class RsServlet {
    private RsServlet() {
        throw new IllegalStateException("Utility class");
    }

    public static Map<String, String[]> getParams(ServletRequest request) {
        Map map = request.getParameterMap();
        return Collections.unmodifiableMap(map);
    }

    public static Map<String, String> getParamMap(ServletRequest request) {
        HashMap<String, String> params = new HashMap<String, String>(16);
        for (Map.Entry<String, String[]> entry : RsServlet.getParams(request).entrySet()) {
            params.put(entry.getKey(), RsArray.join((Object[])entry.getValue(), (CharSequence)","));
        }
        return params;
    }

    public static String getClientIp(HttpServletRequest request, String ... otherHeaderNames) {
        String[] headers = new String[]{"X-Forwarded-For", "X-Real-IP", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_CLIENT_IP", "HTTP_X_FORWARDED_FOR"};
        if (RsArray.isNotEmpty((Object[])otherHeaderNames)) {
            headers = (String[])RsArray.addAll((Object[][])new String[][]{headers, otherHeaderNames});
        }
        return RsServlet.getClientIpByHeader(request, headers);
    }

    public static String getClientIpByHeader(HttpServletRequest request, String ... headerNames) {
        String ip0;
        String ip127;
        String ip = "";
        for (String header : headerNames) {
            ip = request.getHeader(header);
            if (NetUtil.isUnknown((String)ip)) continue;
            ip = NetUtil.getMultistageReverseProxyIp((String)ip);
            break;
        }
        if (NetUtil.isUnknown((String)ip) && (ip127 = "127.0.0.1").equals(ip = request.getRemoteAddr())) {
            try {
                InetAddress inet = InetAddress.getLocalHost();
                ip = inet.getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        if ((ip0 = "0:0:0:0:0:0:0:1").equals(ip = NetUtil.getMultistageReverseProxyIp((String)ip))) {
            ip = "127.0.0.1";
        }
        return ip;
    }

    public static void view(String filePath, String fileType, HttpServletResponse response) {
        File file = new File(filePath);
        RsServlet.view(file, false, fileType, null, null, "UTF-8", response);
    }

    public static void view(File file, String fileType, HttpServletResponse response) {
        RsServlet.view(file, false, fileType, null, null, "UTF-8", response);
    }

    public static void view(String filePath, String fileType, String fileName, HttpServletResponse response) {
        File file = new File(filePath);
        RsServlet.view(file, false, fileType, fileName, null, "UTF-8", response);
    }

    public static void view(File file, String fileType, String fileName, HttpServletResponse response) {
        RsServlet.view(file, false, fileType, fileName, null, "UTF-8", response);
    }

    public static void view(String filePath, boolean preview, String fileType, HttpServletResponse response) {
        File file = new File(filePath);
        RsServlet.view(file, preview, fileType, null, null, "UTF-8", response);
    }

    public static void view(File file, boolean preview, String fileType, HttpServletResponse response) {
        RsServlet.view(file, preview, fileType, null, null, "UTF-8", response);
    }

    public static void view(String filePath, boolean preview, String fileType, String fileName, HttpServletResponse response) {
        File file = new File(filePath);
        RsServlet.view(file, preview, fileType, fileName, null, "UTF-8", response);
    }

    public static void view(File file, boolean preview, String fileType, String fileName, HttpServletResponse response) {
        RsServlet.view(file, preview, fileType, fileName, null, "UTF-8", response);
    }

    public static void view(String filePath, boolean preview, String fileType, Long fileSize, HttpServletResponse response) {
        File file = new File(filePath);
        RsServlet.view(file, preview, fileType, null, fileSize, "UTF-8", response);
    }

    public static void view(File file, boolean preview, String fileType, Long fileSize, HttpServletResponse response) {
        RsServlet.view(file, preview, fileType, null, fileSize, "UTF-8", response);
    }

    public static void view(String filePath, boolean preview, String fileType, String fileName, Long fileSize, HttpServletResponse response) {
        File file = new File(filePath);
        RsServlet.view(file, preview, fileType, fileName, fileSize, "UTF-8", response);
    }

    public static void view(File file, boolean preview, String fileType, String fileName, Long fileSize, HttpServletResponse response) {
        RsServlet.view(file, preview, fileType, fileName, fileSize, "UTF-8", response);
    }

    public static void view(String filePath, boolean preview, String fileType, String fileName, Long fileSize, String charset, HttpServletResponse response) {
        File file = new File(filePath);
        RsServlet.view(file, preview, fileType, fileName, fileSize, charset, response);
    }

    public static void view(File file, boolean preview, String fileType, String fileName, Long fileSize, String charset, HttpServletResponse response) {
        if (!file.exists()) {
            throw new RsException("\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        if (!preview) {
            if (RsString.isBlank((CharSequence)fileName)) {
                fileName = RsFile.getName((File)file);
            } else {
                String ext = "." + RsFile.extName((File)file);
                if (fileName.indexOf(".") == -1 || !fileName.endsWith(ext)) {
                    fileName = fileName + ext;
                }
            }
            try {
                response.addHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(fileName, charset));
            }
            catch (UnsupportedEncodingException ext) {
                // empty catch block
            }
        }
        if (fileSize != null) {
            response.setContentLengthLong(fileSize.longValue());
        }
        response.setContentType(fileType + ";charset=" + charset);
        response.addHeader("Accept-Ranges", "bytes");
        if (fileSize != null && fileSize > 0L) {
            response.addHeader("Content-Range", "bytes 0-" + (fileSize - 1L) + "/" + fileSize);
        }
        response.setBufferSize(0xA00000);
        try (FileInputStream is = new FileInputStream(file);
             BufferedInputStream bis = new BufferedInputStream(is);){
            int bytesRead;
            ServletOutputStream out = response.getOutputStream();
            byte[] buf = new byte[1024];
            while ((bytesRead = bis.read(buf)) > 0) {
                out.write(buf, 0, bytesRead);
            }
        }
        catch (IOException e) {
            throw new RsException("\u8bfb\u53d6\u6587\u4ef6\u51fa\u9519");
        }
    }
}

