/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.extra.mail;

import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.activation.FileDataSource;
import jakarta.activation.FileTypeMap;
import jakarta.mail.Address;
import jakarta.mail.BodyPart;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.SendFailedException;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import jakarta.mail.internet.MimeUtility;
import jakarta.mail.util.ByteArrayDataSource;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.Date;
import top.redscorpion.core.io.IORuntimeException;
import top.redscorpion.core.lang.builder.Builder;
import top.redscorpion.core.util.RsArray;
import top.redscorpion.core.util.RsFile;
import top.redscorpion.core.util.RsIo;
import top.redscorpion.core.util.RsObject;
import top.redscorpion.core.util.RsString;
import top.redscorpion.extra.mail.InternalMailUtil;
import top.redscorpion.extra.mail.MailAccount;
import top.redscorpion.extra.mail.MailException;
import top.redscorpion.extra.mail.RsMail;

public class Mail
implements Builder<MimeMessage> {
    private static final long serialVersionUID = 1L;
    private final MailAccount mailAccount;
    private String[] tos;
    private String[] ccs;
    private String[] bccs;
    private String[] reply;
    private String title;
    private String content;
    private boolean isHtml;
    private final Multipart multipart = new MimeMultipart();
    private boolean useGlobalSession = false;
    private PrintStream debugOutput;

    public static Mail of(MailAccount mailAccount) {
        return new Mail(mailAccount);
    }

    public Mail(MailAccount mailAccount) {
        this.mailAccount = mailAccount.defaultIfEmpty();
    }

    public Mail setTos(String ... tos) {
        this.tos = tos;
        return this;
    }

    public Mail setCcs(String ... ccs) {
        this.ccs = ccs;
        return this;
    }

    public Mail setBccs(String ... bccs) {
        this.bccs = bccs;
        return this;
    }

    public Mail setReply(String ... reply) {
        this.reply = reply;
        return this;
    }

    public Mail setTitle(String title) {
        this.title = title;
        return this;
    }

    public Mail setContent(String content) {
        this.content = content;
        return this;
    }

    public Mail setHtml(boolean isHtml) {
        this.isHtml = isHtml;
        return this;
    }

    public Mail setFiles(File ... files) {
        if (RsArray.isEmpty((Object[])files)) {
            return this;
        }
        DataSource[] attachments = new DataSource[files.length];
        for (int i = 0; i < files.length; ++i) {
            attachments[i] = new FileDataSource(files[i]);
        }
        return this.setAttachments(attachments);
    }

    public Mail addImage(String cid, InputStream imageStream) {
        return this.addImage(cid, imageStream, null);
    }

    public Mail addImage(String cid, InputStream imageStream, String contentType) {
        ByteArrayDataSource imgSource;
        try {
            imgSource = new ByteArrayDataSource(imageStream, (String)RsObject.defaultIfNull((Object)contentType, (Object)"image/jpeg"));
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
        imgSource.setName(cid);
        return this.setAttachments(new DataSource[]{imgSource});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Mail addImage(String cid, File imageFile) {
        Mail mail;
        BufferedInputStream in = null;
        try {
            in = RsFile.getInputStream((File)imageFile);
            mail = this.addImage(cid, in, FileTypeMap.getDefaultFileTypeMap().getContentType(imageFile));
        }
        catch (Throwable throwable) {
            RsIo.closeQuietly((AutoCloseable[])new AutoCloseable[]{in});
            throw throwable;
        }
        RsIo.closeQuietly((AutoCloseable[])new AutoCloseable[]{in});
        return mail;
    }

    public Mail setAttachments(DataSource ... attachments) {
        if (RsArray.isNotEmpty((Object[])attachments)) {
            Charset charset = this.mailAccount.getCharset();
            try {
                for (DataSource attachment : attachments) {
                    MimeBodyPart bodyPart = new MimeBodyPart();
                    bodyPart.setDataHandler(new DataHandler(attachment));
                    String nameEncoded = attachment.getName();
                    if (this.mailAccount.isEncodefilename()) {
                        nameEncoded = InternalMailUtil.encodeText(nameEncoded, charset);
                    }
                    bodyPart.setFileName(nameEncoded);
                    if (RsString.startWith((CharSequence)attachment.getContentType(), (CharSequence)"image/")) {
                        bodyPart.setContentID(nameEncoded);
                        bodyPart.setDisposition("inline");
                    }
                    this.multipart.addBodyPart((BodyPart)bodyPart);
                }
            }
            catch (MessagingException e) {
                throw new MailException(e);
            }
        }
        return this;
    }

    public Mail setCharset(Charset charset) {
        this.mailAccount.setCharset(charset);
        return this;
    }

    public Mail setUseGlobalSession(boolean isUseGlobalSession) {
        this.useGlobalSession = isUseGlobalSession;
        return this;
    }

    public Mail setDebugOutput(PrintStream debugOutput) {
        this.debugOutput = debugOutput;
        return this;
    }

    public MimeMessage build() {
        try {
            return this.buildMsg();
        }
        catch (MessagingException e) {
            throw new MailException(e);
        }
    }

    public String send() throws MailException {
        try {
            return this.doSend();
        }
        catch (MessagingException e) {
            if (e instanceof SendFailedException) {
                Address[] invalidAddresses = ((SendFailedException)e).getInvalidAddresses();
                String msg = RsString.format((CharSequence)"Invalid Addresses: {}", (Object[])new Object[]{RsArray.toString((Object)invalidAddresses)});
                throw new MailException(msg, e);
            }
            throw new MailException(e);
        }
    }

    private String doSend() throws MessagingException {
        MimeMessage mimeMessage = this.buildMsg();
        Transport.send((Message)mimeMessage);
        return mimeMessage.getMessageID();
    }

    private MimeMessage buildMsg() throws MessagingException {
        Charset charset = this.mailAccount.getCharset();
        MimeMessage msg = new MimeMessage(this.getSession());
        String from = this.mailAccount.getFrom();
        if (RsString.isEmpty((CharSequence)from)) {
            msg.setFrom();
        } else {
            msg.setFrom((Address)InternalMailUtil.parseFirstAddress(from, charset));
        }
        msg.setSubject(this.title, null == charset ? null : charset.name());
        msg.setSentDate(new Date());
        msg.setContent(this.buildContent(charset));
        msg.setRecipients(MimeMessage.RecipientType.TO, (Address[])InternalMailUtil.parseAddressFromStrs(this.tos, charset));
        if (RsArray.isNotEmpty((Object[])this.ccs)) {
            msg.setRecipients(MimeMessage.RecipientType.CC, (Address[])InternalMailUtil.parseAddressFromStrs(this.ccs, charset));
        }
        if (RsArray.isNotEmpty((Object[])this.bccs)) {
            msg.setRecipients(MimeMessage.RecipientType.BCC, (Address[])InternalMailUtil.parseAddressFromStrs(this.bccs, charset));
        }
        if (RsArray.isNotEmpty((Object[])this.reply)) {
            msg.setReplyTo((Address[])InternalMailUtil.parseAddressFromStrs(this.reply, charset));
        }
        return msg;
    }

    private Multipart buildContent(Charset charset) throws MessagingException {
        String charsetStr = null != charset ? charset.name() : MimeUtility.getDefaultJavaCharset();
        MimeBodyPart body = new MimeBodyPart();
        body.setContent((Object)this.content, RsString.format((CharSequence)"text/{}; charset={}", (Object[])new Object[]{this.isHtml ? "html" : "plain", charsetStr}));
        this.multipart.addBodyPart((BodyPart)body);
        return this.multipart;
    }

    private Session getSession() {
        Session session = RsMail.getSession(this.mailAccount, this.useGlobalSession);
        if (null != this.debugOutput) {
            session.setDebugOut(this.debugOutput);
        }
        return session;
    }
}

