/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.extra.setting;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.UnaryOperator;
import top.redscorpion.core.io.LineReader;
import top.redscorpion.core.io.resource.Resource;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.util.RsCharset;
import top.redscorpion.core.util.RsFile;
import top.redscorpion.core.util.RsIo;
import top.redscorpion.core.util.RsRegular;
import top.redscorpion.core.util.RsSplit;
import top.redscorpion.core.util.RsString;
import top.redscorpion.core.util.RsSystem;
import top.redscorpion.extra.setting.GroupedMap;
import top.redscorpion.log.Log;

public class SettingLoader {
    private static final Log log = Log.get();
    private static final char COMMENT_FLAG_PRE = '#';
    private final Charset charset;
    private final boolean isUseVariable;
    private final GroupedMap groupedMap;
    private char assignFlag = (char)61;
    private String varRegex = "\\$\\{(.*?)\\}";
    private UnaryOperator<String> valueEditor;

    public SettingLoader(GroupedMap groupedMap) {
        this(groupedMap, RsCharset.UTF_8, false);
    }

    public SettingLoader(GroupedMap groupedMap, Charset charset, boolean isUseVariable) {
        this.groupedMap = groupedMap;
        this.charset = charset;
        this.isUseVariable = isUseVariable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load(Resource resource) {
        if (resource == null) {
            throw new NullPointerException("Null setting url define!");
        }
        log.debug("Load setting file [{}]", new Object[]{resource});
        InputStream settingStream = null;
        try {
            settingStream = resource.getStream();
            this.load(settingStream);
        }
        catch (Exception e) {
            boolean bl;
            try {
                log.error((Throwable)e, "Load setting error!", new Object[0]);
                bl = false;
            }
            catch (Throwable throwable) {
                RsIo.closeQuietly((AutoCloseable[])new AutoCloseable[]{settingStream});
                throw throwable;
            }
            RsIo.closeQuietly((AutoCloseable[])new AutoCloseable[]{settingStream});
            return bl;
        }
        RsIo.closeQuietly((AutoCloseable[])new AutoCloseable[]{settingStream});
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void load(InputStream settingStream) throws IOException {
        this.groupedMap.clear();
        LineReader reader = null;
        try {
            String line;
            reader = new LineReader(settingStream, this.charset);
            String group = null;
            while ((line = reader.readLine()) != null) {
                if (RsString.isBlank((CharSequence)(line = RsString.trim((CharSequence)line))) || RsString.startWith((CharSequence)line, (char)'#')) continue;
                if (RsString.isWrap((CharSequence)line, (char)'[', (char)']')) {
                    group = RsString.trim((CharSequence)line.substring(1, line.length() - 1));
                    continue;
                }
                String[] keyValue = RsSplit.split((CharSequence)line, (CharSequence)String.valueOf(this.assignFlag), (int)2, (boolean)true, (boolean)false).toArray(new String[0]);
                if (keyValue.length < 2) continue;
                String value = keyValue[1];
                if (null != this.valueEditor) {
                    value = (String)this.valueEditor.apply(value);
                }
                if (this.isUseVariable) {
                    value = this.replaceVar(group, value);
                }
                this.groupedMap.put(group, RsString.trim((CharSequence)keyValue[0]), value);
            }
        }
        catch (Throwable throwable) {
            RsIo.closeQuietly((AutoCloseable[])new AutoCloseable[]{reader});
            throw throwable;
        }
        RsIo.closeQuietly((AutoCloseable[])new AutoCloseable[]{reader});
    }

    public SettingLoader setVarRegex(String regex) {
        this.varRegex = regex;
        return this;
    }

    public SettingLoader setAssignFlag(char assignFlag) {
        this.assignFlag = assignFlag;
        return this;
    }

    public SettingLoader setValueEditor(UnaryOperator<String> valueEditor) {
        this.valueEditor = valueEditor;
        return this;
    }

    public void store(String absolutePath) {
        this.store(RsFile.touch((String)absolutePath));
    }

    public void store(File file) {
        Assert.notNull((Object)file, (String)"File to store must be not null !", (Object[])new Object[0]);
        log.debug("Store Setting to [{}]...", new Object[]{file.getAbsolutePath()});
        PrintWriter writer = null;
        try {
            writer = RsFile.getPrintWriter((File)file, (Charset)this.charset, (boolean)false);
            this.store(writer);
        }
        catch (Throwable throwable) {
            RsIo.closeQuietly((AutoCloseable[])new AutoCloseable[]{writer});
            throw throwable;
        }
        RsIo.closeQuietly((AutoCloseable[])new AutoCloseable[]{writer});
    }

    private synchronized void store(PrintWriter writer) {
        for (Map.Entry<String, LinkedHashMap<String, String>> groupEntry : this.groupedMap.entrySet()) {
            writer.println(RsString.format((CharSequence)"{}{}{}", (Object[])new Object[]{Character.valueOf('['), groupEntry.getKey(), Character.valueOf(']')}));
            for (Map.Entry<String, String> entry : groupEntry.getValue().entrySet()) {
                writer.println(RsString.format((CharSequence)"{} {} {}", (Object[])new Object[]{entry.getKey(), Character.valueOf(this.assignFlag), entry.getValue()}));
            }
        }
    }

    private String replaceVar(String group, String value) {
        Set vars = (Set)RsRegular.findAll((String)this.varRegex, (CharSequence)value, (int)0, new HashSet());
        for (String var : vars) {
            List groupAndKey;
            String key = RsRegular.get((String)this.varRegex, (CharSequence)var, (int)1);
            if (!RsString.isNotBlank((CharSequence)key)) continue;
            String varValue = this.groupedMap.get(group, key);
            if (null == varValue && (groupAndKey = RsSplit.split((CharSequence)key, (CharSequence)".", (int)2, (boolean)true, (boolean)false)).size() > 1) {
                varValue = this.groupedMap.get((CharSequence)groupAndKey.get(0), (CharSequence)groupAndKey.get(1));
            }
            if (null == varValue) {
                varValue = RsSystem.get((String)key);
            }
            if (null == varValue) continue;
            value = value.replace(var, varValue);
        }
        return value;
    }
}

