/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.extra.setting;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import top.redscorpion.core.io.LineReader;
import top.redscorpion.core.io.resource.NoResourceException;
import top.redscorpion.core.io.resource.Resource;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.util.RsFile;
import top.redscorpion.core.util.RsIo;
import top.redscorpion.core.util.RsRegular;
import top.redscorpion.core.util.RsSplit;
import top.redscorpion.core.util.RsString;
import top.redscorpion.core.util.RsSystem;
import top.redscorpion.extra.setting.GroupedMap;
import top.redscorpion.log.Log;

public class SettingLoader {
    private static final Log log = Log.get();
    private static final char COMMENT_FLAG_PRE = '#';
    private final Charset charset;
    private final boolean isUseVariable;
    private char assignFlag = (char)61;
    private String varRegex = "\\$\\{(.*?)\\}";
    private ValueEditor valueEditor;

    public SettingLoader(Charset charset, boolean isUseVariable) {
        this.charset = charset;
        this.isUseVariable = isUseVariable;
    }

    public SettingLoader setVarRegex(String regex) {
        this.varRegex = regex;
        return this;
    }

    public SettingLoader setAssignFlag(char assignFlag) {
        this.assignFlag = assignFlag;
        return this;
    }

    public SettingLoader setValueEditor(ValueEditor valueEditor) {
        this.valueEditor = valueEditor;
        return this;
    }

    public GroupedMap load(Resource resource) throws NoResourceException {
        GroupedMap groupedMap;
        Assert.notNull((Object)resource, (String)"Null setting url define!", (Object[])new Object[0]);
        InputStream settingStream = null;
        try {
            settingStream = resource.getStream();
            groupedMap = this.load(settingStream);
            log.debug("Load setting file [{}]", new Object[]{resource});
        }
        catch (Exception e) {
            try {
                if (e instanceof NoResourceException) {
                    throw (NoResourceException)((Object)e);
                }
                throw new NoResourceException((Throwable)e);
            }
            catch (Throwable throwable) {
                RsIo.closeQuietly((AutoCloseable[])new AutoCloseable[]{settingStream});
                throw throwable;
            }
        }
        RsIo.closeQuietly((AutoCloseable[])new AutoCloseable[]{settingStream});
        return groupedMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized GroupedMap load(InputStream settingStream) throws IOException {
        GroupedMap groupedMap = new GroupedMap();
        LineReader reader = null;
        try {
            String line;
            reader = new LineReader(settingStream, this.charset);
            String group = null;
            while ((line = reader.readLine()) != null) {
                if (RsString.isBlank((CharSequence)(line = RsString.trim((CharSequence)line))) || RsString.startWith((CharSequence)line, (char)'#')) continue;
                if (RsString.isWrap((CharSequence)line, (char)'[', (char)']')) {
                    group = RsString.trim((CharSequence)line.substring(1, line.length() - 1));
                    continue;
                }
                String[] keyValue = RsSplit.split((CharSequence)line, (CharSequence)String.valueOf(this.assignFlag), (int)2, (boolean)true, (boolean)false).toArray(new String[0]);
                if (keyValue.length < 2) continue;
                String key = RsString.trim((CharSequence)keyValue[0]);
                String value = keyValue[1];
                if (null != this.valueEditor) {
                    value = this.valueEditor.edit(group, key, value);
                }
                if (this.isUseVariable) {
                    value = this.replaceVar(groupedMap, group, value);
                }
                groupedMap.put(group, key, value);
            }
        }
        catch (Throwable throwable) {
            RsIo.closeQuietly((AutoCloseable[])new AutoCloseable[]{reader});
            throw throwable;
        }
        RsIo.closeQuietly((AutoCloseable[])new AutoCloseable[]{reader});
        return groupedMap;
    }

    public void store(GroupedMap groupedMap, String absolutePath) {
        this.store(groupedMap, RsFile.touch((String)absolutePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(GroupedMap groupedMap, File file) {
        Assert.notNull((Object)file, (String)"File to store must be not null !", (Object[])new Object[0]);
        log.debug("Store Setting to [{}]...", new Object[]{file.getAbsolutePath()});
        PrintWriter writer = null;
        try {
            writer = RsFile.getPrintWriter((File)file, (Charset)this.charset, (boolean)false);
            this.store(groupedMap, writer);
        }
        catch (Throwable throwable) {
            RsIo.closeQuietly((AutoCloseable[])new AutoCloseable[]{writer});
            throw throwable;
        }
        RsIo.closeQuietly((AutoCloseable[])new AutoCloseable[]{writer});
    }

    private synchronized void store(GroupedMap groupedMap, PrintWriter writer) {
        for (Map.Entry<String, LinkedHashMap<String, String>> groupEntry : groupedMap.entrySet()) {
            writer.println(RsString.format((CharSequence)"{}{}{}", (Object[])new Object[]{Character.valueOf('['), groupEntry.getKey(), Character.valueOf(']')}));
            for (Map.Entry<String, String> entry : groupEntry.getValue().entrySet()) {
                writer.println(RsString.format((CharSequence)"{} {} {}", (Object[])new Object[]{entry.getKey(), Character.valueOf(this.assignFlag), entry.getValue()}));
            }
        }
    }

    private String replaceVar(GroupedMap groupedMap, String group, String value) {
        Set vars = (Set)RsRegular.findAll((String)this.varRegex, (CharSequence)value, (int)0, new HashSet());
        for (String var : vars) {
            List groupAndKey;
            String key = RsRegular.get((String)this.varRegex, (CharSequence)var, (int)1);
            if (!RsString.isNotBlank((CharSequence)key)) continue;
            String varValue = groupedMap.get(group, key);
            if (null == varValue && (groupAndKey = RsSplit.split((CharSequence)key, (CharSequence)".", (int)2, (boolean)true, (boolean)false)).size() > 1) {
                varValue = groupedMap.get((CharSequence)groupAndKey.get(0), (CharSequence)groupAndKey.get(1));
            }
            if (null == varValue) {
                varValue = RsSystem.get((String)key);
            }
            if (null == varValue) continue;
            value = value.replace(var, varValue);
        }
        return value;
    }

    @FunctionalInterface
    public static interface ValueEditor {
        public String edit(String var1, String var2, String var3);
    }
}

