/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.pdf;

import com.itextpdf.html2pdf.ConverterProperties;
import com.itextpdf.html2pdf.HtmlConverter;
import com.itextpdf.kernel.events.IEventHandler;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.font.PdfFontFactory;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfWriter;
import com.itextpdf.layout.font.FontProvider;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import top.redscorpion.pdf.PdfConvertException;
import top.redscorpion.pdf.PdfSetting;
import top.redscorpion.pdf.event.FooterEventHandler;
import top.redscorpion.pdf.event.HeaderEventHandler;
import top.redscorpion.pdf.event.WaterMarkEventHandler;

public class RsPdf {
    public static void filePathTo(String htmlFilePath, String outFilePath) {
        RsPdf.filePathTo(htmlFilePath, outFilePath, new PdfSetting());
    }

    public static void filePathTo(String htmlFilePath, String outFilePath, PdfSetting pdfSetting) {
        try {
            PdfWriter pdfWriter = new PdfWriter(outFilePath);
            PdfDocument pdfDocument = RsPdf.setPdfDocument(pdfWriter, pdfSetting);
            ConverterProperties properties = RsPdf.setConverterProperties(pdfSetting);
            HtmlConverter.convertToPdf((String)RsPdf.readHtmlFile(htmlFilePath), (PdfDocument)pdfDocument, (ConverterProperties)properties);
            pdfWriter.close();
            pdfDocument.close();
        }
        catch (IOException e) {
            throw new PdfConvertException("RS-PDF Error:Pdf file generation failed.");
        }
    }

    public static void filePathTo(String htmlFilePath, File outFile) {
        RsPdf.filePathTo(htmlFilePath, outFile, new PdfSetting());
    }

    public static void filePathTo(String htmlFilePath, File outFile, PdfSetting pdfSetting) {
        try {
            PdfWriter pdfWriter = new PdfWriter(outFile);
            PdfDocument pdfDocument = RsPdf.setPdfDocument(pdfWriter, pdfSetting);
            ConverterProperties properties = RsPdf.setConverterProperties(pdfSetting);
            HtmlConverter.convertToPdf((String)RsPdf.readHtmlFile(htmlFilePath), (PdfDocument)pdfDocument, (ConverterProperties)properties);
            pdfWriter.close();
            pdfDocument.close();
        }
        catch (IOException e) {
            throw new PdfConvertException("RS-PDF Error:Pdf file generation failed.");
        }
    }

    public static void filePathTo(String htmlFilePath, OutputStream os) {
        RsPdf.filePathTo(htmlFilePath, os, new PdfSetting());
    }

    public static void filePathTo(String htmlFilePath, OutputStream os, PdfSetting pdfSetting) {
        try {
            PdfWriter pdfWriter = new PdfWriter(os);
            PdfDocument pdfDocument = RsPdf.setPdfDocument(pdfWriter, pdfSetting);
            ConverterProperties properties = RsPdf.setConverterProperties(pdfSetting);
            HtmlConverter.convertToPdf((String)RsPdf.readHtmlFile(htmlFilePath), (PdfDocument)pdfDocument, (ConverterProperties)properties);
            pdfWriter.close();
            pdfDocument.close();
        }
        catch (IOException e) {
            throw new PdfConvertException("RS-PDF Error:Pdf file generation failed.");
        }
    }

    public static void to(String htmlStr, String outFilePath) {
        RsPdf.to(htmlStr, outFilePath, new PdfSetting());
    }

    public static void to(String htmlStr, String outFilePath, PdfSetting pdfSetting) {
        try {
            PdfWriter pdfWriter = new PdfWriter(outFilePath);
            PdfDocument pdfDocument = RsPdf.setPdfDocument(pdfWriter, pdfSetting);
            ConverterProperties properties = RsPdf.setConverterProperties(pdfSetting);
            HtmlConverter.convertToPdf((String)htmlStr, (PdfDocument)pdfDocument, (ConverterProperties)properties);
            pdfWriter.close();
            pdfDocument.close();
        }
        catch (IOException e) {
            throw new PdfConvertException("RS-PDF Error:Pdf file generation failed.");
        }
    }

    public static void to(String htmlStr, File outFile) {
        RsPdf.to(htmlStr, outFile, new PdfSetting());
    }

    public static void to(String htmlStr, File outFile, PdfSetting pdfSetting) {
        try {
            PdfWriter pdfWriter = new PdfWriter(outFile);
            PdfDocument pdfDocument = RsPdf.setPdfDocument(pdfWriter, pdfSetting);
            ConverterProperties properties = RsPdf.setConverterProperties(pdfSetting);
            HtmlConverter.convertToPdf((String)htmlStr, (PdfDocument)pdfDocument, (ConverterProperties)properties);
            pdfWriter.close();
            pdfDocument.close();
        }
        catch (IOException e) {
            throw new PdfConvertException("RS-PDF Error:Pdf file generation failed.");
        }
    }

    public static void to(String htmlStr, OutputStream os) {
        RsPdf.to(htmlStr, os, new PdfSetting());
    }

    public static void to(String htmlStr, OutputStream os, PdfSetting pdfSetting) {
        try {
            PdfWriter pdfWriter = new PdfWriter(os);
            PdfDocument pdfDocument = RsPdf.setPdfDocument(pdfWriter, pdfSetting);
            ConverterProperties properties = RsPdf.setConverterProperties(pdfSetting);
            HtmlConverter.convertToPdf((String)htmlStr, (PdfDocument)pdfDocument, (ConverterProperties)properties);
            pdfWriter.close();
            pdfDocument.close();
        }
        catch (IOException e) {
            throw new PdfConvertException("RS-PDF Error:Pdf file generation failed.");
        }
    }

    public static void to(File htmlFile, String outFilePath) {
        RsPdf.to(htmlFile, outFilePath, new PdfSetting());
    }

    public static void to(File htmlFile, String outFilePath, PdfSetting pdfSetting) {
        try {
            PdfWriter pdfWriter = new PdfWriter(outFilePath);
            PdfDocument pdfDocument = RsPdf.setPdfDocument(pdfWriter, pdfSetting);
            ConverterProperties properties = RsPdf.setConverterProperties(pdfSetting);
            HtmlConverter.convertToPdf((String)RsPdf.readHtmlFile(htmlFile), (PdfDocument)pdfDocument, (ConverterProperties)properties);
            pdfWriter.close();
            pdfDocument.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void to(File htmlFile, File outFile) {
        RsPdf.to(htmlFile, outFile, new PdfSetting());
    }

    public static void to(File htmlFile, File outFile, PdfSetting pdfSetting) {
        try {
            PdfWriter pdfWriter = new PdfWriter(outFile);
            PdfDocument pdfDocument = RsPdf.setPdfDocument(pdfWriter, pdfSetting);
            ConverterProperties properties = RsPdf.setConverterProperties(pdfSetting);
            HtmlConverter.convertToPdf((String)RsPdf.readHtmlFile(htmlFile), (PdfDocument)pdfDocument, (ConverterProperties)properties);
            pdfWriter.close();
            pdfDocument.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void to(File htmlFile, OutputStream os) {
        RsPdf.to(htmlFile, os, new PdfSetting());
    }

    public static void to(File htmlFile, OutputStream os, PdfSetting pdfSetting) {
        try {
            PdfWriter pdfWriter = new PdfWriter(os);
            PdfDocument pdfDocument = RsPdf.setPdfDocument(pdfWriter, pdfSetting);
            ConverterProperties properties = RsPdf.setConverterProperties(pdfSetting);
            HtmlConverter.convertToPdf((String)RsPdf.readHtmlFile(htmlFile), (PdfDocument)pdfDocument, (ConverterProperties)properties);
            pdfWriter.close();
            pdfDocument.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void to(InputStream htmlStream, String outFilePath) {
        RsPdf.to(htmlStream, outFilePath, new PdfSetting());
    }

    public static void to(InputStream htmlStream, String outFilePath, PdfSetting pdfSetting) {
        try {
            PdfWriter pdfWriter = new PdfWriter(outFilePath);
            PdfDocument pdfDocument = RsPdf.setPdfDocument(pdfWriter, pdfSetting);
            ConverterProperties properties = RsPdf.setConverterProperties(pdfSetting);
            HtmlConverter.convertToPdf((InputStream)RsPdf.readInputStrem(htmlStream), (PdfDocument)pdfDocument, (ConverterProperties)properties);
            pdfWriter.close();
            pdfDocument.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void to(InputStream htmlStream, File outFile) {
        RsPdf.to(htmlStream, outFile, new PdfSetting());
    }

    public static void to(InputStream htmlStream, File outFile, PdfSetting pdfSetting) {
        try {
            PdfWriter pdfWriter = new PdfWriter(outFile);
            PdfDocument pdfDocument = RsPdf.setPdfDocument(pdfWriter, pdfSetting);
            ConverterProperties properties = RsPdf.setConverterProperties(pdfSetting);
            HtmlConverter.convertToPdf((InputStream)RsPdf.readInputStrem(htmlStream), (PdfDocument)pdfDocument, (ConverterProperties)properties);
            pdfWriter.close();
            pdfDocument.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void to(InputStream htmlStream, OutputStream os) {
        RsPdf.to(htmlStream, os, new PdfSetting());
    }

    public static void to(InputStream htmlStream, OutputStream os, PdfSetting pdfSetting) {
        try {
            PdfWriter pdfWriter = new PdfWriter(os);
            PdfDocument pdfDocument = RsPdf.setPdfDocument(pdfWriter, pdfSetting);
            ConverterProperties properties = RsPdf.setConverterProperties(pdfSetting);
            HtmlConverter.convertToPdf((InputStream)RsPdf.readInputStrem(htmlStream), (PdfDocument)pdfDocument, (ConverterProperties)properties);
            pdfWriter.close();
            pdfDocument.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static PdfDocument setPdfDocument(PdfWriter pdfWriter, PdfSetting pdfSetting) {
        PdfDocument pdfDocument = new PdfDocument(pdfWriter);
        pdfDocument.setDefaultPageSize(pdfSetting.getPageSize());
        if (pdfSetting.getWaterMark() != null && !"".equals(pdfSetting.getWaterMark())) {
            pdfDocument.addEventHandler("EndPdfPage", (IEventHandler)new WaterMarkEventHandler(pdfSetting.getWaterMark()));
        }
        if (pdfSetting.getHeader() != null) {
            pdfDocument.addEventHandler("EndPdfPage", (IEventHandler)new HeaderEventHandler(pdfSetting.getHeader()));
        }
        if (pdfSetting.getFooter() != null) {
            pdfDocument.addEventHandler("EndPdfPage", (IEventHandler)new FooterEventHandler(pdfSetting.getFooter()));
        }
        return pdfDocument;
    }

    private static ConverterProperties setConverterProperties(PdfSetting pdfSetting) {
        ConverterProperties properties = new ConverterProperties();
        FontProvider fontProvider = new FontProvider();
        try {
            if (pdfSetting.getFontPath() != null && !"".equals(pdfSetting.getFontPath())) {
                PdfFont microsoft = PdfFontFactory.createFont((String)pdfSetting.getFontPath(), (String)"Identity-H");
                fontProvider.addFont(microsoft.getFontProgram(), "Identity-H");
            } else {
                PdfFont sysFont = PdfFontFactory.createFont((String)"STSongStd-Light", (String)"UniGB-UCS2-H");
                fontProvider.addFont(sysFont.getFontProgram(), "UniGB-UCS2-H");
                PdfFont m2 = PdfFontFactory.createFont((String)"/fonts/AlibabaPuHuiTi-2-85-Bold.ttf", (String)"Identity-H");
                fontProvider.addFont(m2.getFontProgram(), "Identity-H");
            }
            properties.setFontProvider(fontProvider);
        }
        catch (IOException e) {
            throw new PdfConvertException("RS-PDF Error:SetConverterProperties failed.");
        }
        return properties;
    }

    private static InputStream readInputStrem(InputStream inputStream) {
        String regExSpecial = "\\&[a-zA-Z]{1,10};";
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            int len = -1;
            while ((len = inputStream.read(buffer)) != -1) {
                baos.write(buffer, 0, len);
            }
            String content = baos.toString();
            baos.close();
            Pattern compile = Pattern.compile(regExSpecial, 2);
            Matcher matcher = compile.matcher(content);
            String replaceAll = matcher.replaceAll("");
            InputStream stringStream = RsPdf.getStringStream(replaceAll);
            return stringStream;
        }
        catch (Exception e) {
            throw new PdfConvertException("RS-PDF Error:Pdf failed.");
        }
    }

    private static InputStream getStringStream(String sInputString) {
        if (sInputString != null && !"".equals(sInputString.trim())) {
            try {
                ByteArrayInputStream tInputStringStream = new ByteArrayInputStream(sInputString.getBytes());
                return tInputStringStream;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static String readHtmlFile(String path) {
        File file = new File(path);
        return RsPdf.readHtmlFile(file);
    }

    public static String readHtmlFile(File file) {
        StringBuffer textHtml = new StringBuffer();
        try {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            String tempString = null;
            while ((tempString = reader.readLine()) != null) {
                textHtml.append(tempString);
            }
            reader.close();
        }
        catch (IOException e) {
            return null;
        }
        return textHtml.toString();
    }

    public static String format(String str, int page, int total) {
        String newStr = str;
        if (newStr.indexOf("${page}") > 0) {
            newStr = newStr.replace("${page}", String.valueOf(page));
        }
        if (newStr.indexOf("${total}") > 0) {
            newStr = newStr.replace("${total}", String.valueOf(total));
        }
        return newStr;
    }
}

