/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.pdf;

import com.itextpdf.html2pdf.ConverterProperties;
import com.itextpdf.html2pdf.HtmlConverter;
import com.itextpdf.kernel.events.IEventHandler;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.font.PdfFontFactory;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfReader;
import com.itextpdf.kernel.pdf.PdfWriter;
import com.itextpdf.kernel.utils.PdfMerger;
import com.itextpdf.layout.font.FontProvider;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import top.redscorpion.core.util.RsFile;
import top.redscorpion.pdf.FontSetting;
import top.redscorpion.pdf.PdfConvertException;
import top.redscorpion.pdf.PdfSetting;
import top.redscorpion.pdf.event.FooterEventHandler;
import top.redscorpion.pdf.event.HeaderEventHandler;
import top.redscorpion.pdf.event.WaterMarkEventHandler;

public class RsPdf {
    public static void filePathTo(String htmlFilePath, String outFilePath) {
        RsPdf.filePathTo(htmlFilePath, outFilePath, new PdfSetting());
    }

    public static void filePathTo(String htmlFilePath, String outFilePath, PdfSetting pdfSetting) {
        try {
            RsFile.mkParentDirs((File)new File(outFilePath));
            PdfWriter pdfWriter = new PdfWriter(outFilePath);
            PdfDocument pdfDocument = RsPdf.setPdfDocument(pdfWriter, pdfSetting);
            ConverterProperties properties = RsPdf.setConverterProperties(pdfSetting);
            HtmlConverter.convertToPdf((String)RsPdf.readHtmlFile(htmlFilePath), (PdfDocument)pdfDocument, (ConverterProperties)properties);
            pdfWriter.close();
            pdfDocument.close();
        }
        catch (IOException e) {
            throw new PdfConvertException("[RS-PDF]Pdf file generation failed:{}", e.getMessage());
        }
    }

    public static void filePathTo(String htmlFilePath, File outFile) {
        RsPdf.filePathTo(htmlFilePath, outFile, new PdfSetting());
    }

    public static void filePathTo(String htmlFilePath, File outFile, PdfSetting pdfSetting) {
        try {
            RsFile.mkParentDirs((File)outFile);
            PdfWriter pdfWriter = new PdfWriter(outFile);
            PdfDocument pdfDocument = RsPdf.setPdfDocument(pdfWriter, pdfSetting);
            ConverterProperties properties = RsPdf.setConverterProperties(pdfSetting);
            HtmlConverter.convertToPdf((String)RsPdf.readHtmlFile(htmlFilePath), (PdfDocument)pdfDocument, (ConverterProperties)properties);
            pdfWriter.close();
            pdfDocument.close();
        }
        catch (IOException e) {
            throw new PdfConvertException("[RS-PDF]Pdf file generation failed:{}", e.getMessage());
        }
    }

    public static void filePathTo(String htmlFilePath, OutputStream os) {
        RsPdf.filePathTo(htmlFilePath, os, new PdfSetting());
    }

    public static void filePathTo(String htmlFilePath, OutputStream os, PdfSetting pdfSetting) {
        try {
            PdfWriter pdfWriter = new PdfWriter(os);
            PdfDocument pdfDocument = RsPdf.setPdfDocument(pdfWriter, pdfSetting);
            ConverterProperties properties = RsPdf.setConverterProperties(pdfSetting);
            HtmlConverter.convertToPdf((String)RsPdf.readHtmlFile(htmlFilePath), (PdfDocument)pdfDocument, (ConverterProperties)properties);
            pdfWriter.close();
            pdfDocument.close();
        }
        catch (IOException e) {
            throw new PdfConvertException("[RS-PDF]Pdf file generation failed:{}", e.getMessage());
        }
    }

    public static void to(String htmlStr, String outFilePath) {
        RsPdf.to(htmlStr, outFilePath, new PdfSetting());
    }

    public static void to(String htmlStr, String outFilePath, PdfSetting pdfSetting) {
        try {
            RsFile.mkParentDirs((File)new File(outFilePath));
            PdfWriter pdfWriter = new PdfWriter(outFilePath);
            PdfDocument pdfDocument = RsPdf.setPdfDocument(pdfWriter, pdfSetting);
            ConverterProperties properties = RsPdf.setConverterProperties(pdfSetting);
            HtmlConverter.convertToPdf((String)htmlStr, (PdfDocument)pdfDocument, (ConverterProperties)properties);
            pdfWriter.close();
            pdfDocument.close();
        }
        catch (IOException e) {
            throw new PdfConvertException("[RS-PDF]Pdf file generation failed:{}", e.getMessage());
        }
    }

    public static void to(String htmlStr, File outFile) {
        RsPdf.to(htmlStr, outFile, new PdfSetting());
    }

    public static void to(String htmlStr, File outFile, PdfSetting pdfSetting) {
        try {
            RsFile.mkParentDirs((File)outFile);
            PdfWriter pdfWriter = new PdfWriter(outFile);
            PdfDocument pdfDocument = RsPdf.setPdfDocument(pdfWriter, pdfSetting);
            ConverterProperties properties = RsPdf.setConverterProperties(pdfSetting);
            HtmlConverter.convertToPdf((String)htmlStr, (PdfDocument)pdfDocument, (ConverterProperties)properties);
            pdfWriter.close();
            pdfDocument.close();
        }
        catch (IOException e) {
            throw new PdfConvertException("[RS-PDF]Pdf file generation failed:{}", e.getMessage());
        }
    }

    public static void to(String htmlStr, OutputStream os) {
        RsPdf.to(htmlStr, os, new PdfSetting());
    }

    public static void to(String htmlStr, OutputStream os, PdfSetting pdfSetting) {
        try {
            PdfWriter pdfWriter = new PdfWriter(os);
            PdfDocument pdfDocument = RsPdf.setPdfDocument(pdfWriter, pdfSetting);
            ConverterProperties properties = RsPdf.setConverterProperties(pdfSetting);
            HtmlConverter.convertToPdf((String)htmlStr, (PdfDocument)pdfDocument, (ConverterProperties)properties);
            pdfWriter.close();
            pdfDocument.close();
        }
        catch (IOException e) {
            throw new PdfConvertException("[RS-PDF]Pdf file generation failed:{}", e.getMessage());
        }
    }

    public static void fileTo(File htmlFile, String outFilePath) {
        RsPdf.fileTo(htmlFile, outFilePath, new PdfSetting());
    }

    public static void fileTo(File htmlFile, String outFilePath, PdfSetting pdfSetting) {
        try {
            RsFile.mkParentDirs((File)new File(outFilePath));
            PdfWriter pdfWriter = new PdfWriter(outFilePath);
            PdfDocument pdfDocument = RsPdf.setPdfDocument(pdfWriter, pdfSetting);
            ConverterProperties properties = RsPdf.setConverterProperties(pdfSetting);
            HtmlConverter.convertToPdf((String)RsPdf.readHtmlFile(htmlFile), (PdfDocument)pdfDocument, (ConverterProperties)properties);
            pdfWriter.close();
            pdfDocument.close();
        }
        catch (IOException e) {
            throw new PdfConvertException("[RS-PDF]Pdf file generation failed:{}", e.getMessage());
        }
    }

    public static void fileTo(File htmlFile, File outFile) {
        RsPdf.fileTo(htmlFile, outFile, new PdfSetting());
    }

    public static void fileTo(File htmlFile, File outFile, PdfSetting pdfSetting) {
        try {
            RsFile.mkParentDirs((File)outFile);
            PdfWriter pdfWriter = new PdfWriter(outFile);
            PdfDocument pdfDocument = RsPdf.setPdfDocument(pdfWriter, pdfSetting);
            ConverterProperties properties = RsPdf.setConverterProperties(pdfSetting);
            HtmlConverter.convertToPdf((String)RsPdf.readHtmlFile(htmlFile), (PdfDocument)pdfDocument, (ConverterProperties)properties);
            pdfWriter.close();
            pdfDocument.close();
        }
        catch (IOException e) {
            throw new PdfConvertException("[RS-PDF]Pdf file generation failed:{}", e.getMessage());
        }
    }

    public static void fileTo(File htmlFile, OutputStream os) {
        RsPdf.fileTo(htmlFile, os, new PdfSetting());
    }

    public static void fileTo(File htmlFile, OutputStream os, PdfSetting pdfSetting) {
        try {
            PdfWriter pdfWriter = new PdfWriter(os);
            PdfDocument pdfDocument = RsPdf.setPdfDocument(pdfWriter, pdfSetting);
            ConverterProperties properties = RsPdf.setConverterProperties(pdfSetting);
            HtmlConverter.convertToPdf((String)RsPdf.readHtmlFile(htmlFile), (PdfDocument)pdfDocument, (ConverterProperties)properties);
            pdfWriter.close();
            pdfDocument.close();
        }
        catch (IOException e) {
            throw new PdfConvertException("[RS-PDF]Pdf file generation failed:{}", e.getMessage());
        }
    }

    public static void streamTo(InputStream htmlStream, String outFilePath) {
        RsPdf.streamTo(htmlStream, outFilePath, new PdfSetting());
    }

    public static void streamTo(InputStream htmlStream, String outFilePath, PdfSetting pdfSetting) {
        try {
            RsFile.mkParentDirs((File)new File(outFilePath));
            PdfWriter pdfWriter = new PdfWriter(outFilePath);
            PdfDocument pdfDocument = RsPdf.setPdfDocument(pdfWriter, pdfSetting);
            ConverterProperties properties = RsPdf.setConverterProperties(pdfSetting);
            HtmlConverter.convertToPdf((InputStream)RsPdf.readInputStream(htmlStream), (PdfDocument)pdfDocument, (ConverterProperties)properties);
            pdfWriter.close();
            pdfDocument.close();
        }
        catch (IOException e) {
            throw new PdfConvertException("[RS-PDF]Pdf file generation failed:{}", e.getMessage());
        }
    }

    public static void streamTo(InputStream htmlStream, File outFile) {
        RsPdf.streamTo(htmlStream, outFile, new PdfSetting());
    }

    public static void streamTo(InputStream htmlStream, File outFile, PdfSetting pdfSetting) {
        try {
            RsFile.mkParentDirs((File)outFile);
            PdfWriter pdfWriter = new PdfWriter(outFile);
            PdfDocument pdfDocument = RsPdf.setPdfDocument(pdfWriter, pdfSetting);
            ConverterProperties properties = RsPdf.setConverterProperties(pdfSetting);
            HtmlConverter.convertToPdf((InputStream)RsPdf.readInputStream(htmlStream), (PdfDocument)pdfDocument, (ConverterProperties)properties);
            pdfWriter.close();
            pdfDocument.close();
        }
        catch (IOException e) {
            throw new PdfConvertException("[RS-PDF]Pdf file generation failed:{}", e.getMessage());
        }
    }

    public static void streamTo(InputStream htmlStream, OutputStream os) {
        RsPdf.streamTo(htmlStream, os, new PdfSetting());
    }

    public static void streamTo(InputStream htmlStream, OutputStream os, PdfSetting pdfSetting) {
        try {
            PdfWriter pdfWriter = new PdfWriter(os);
            PdfDocument pdfDocument = RsPdf.setPdfDocument(pdfWriter, pdfSetting);
            ConverterProperties properties = RsPdf.setConverterProperties(pdfSetting);
            HtmlConverter.convertToPdf((InputStream)RsPdf.readInputStream(htmlStream), (PdfDocument)pdfDocument, (ConverterProperties)properties);
            pdfWriter.close();
            pdfDocument.close();
        }
        catch (IOException e) {
            throw new PdfConvertException("[RS-PDF]Pdf file generation failed:{}", e.getMessage());
        }
    }

    public static boolean merge(List<String> sources, String outFilePath) {
        return RsPdf.merge(sources, outFilePath, true);
    }

    public static boolean merge(List<String> sources, String outFilePath, boolean smartMode) {
        boolean result = false;
        try {
            RsFile.mkParentDirs((File)new File(outFilePath));
            PdfDocument mergedDoc = new PdfDocument(new PdfWriter(outFilePath));
            mergedDoc.getWriter().setSmartMode(smartMode);
            PdfMerger merger = new PdfMerger(mergedDoc);
            for (String source : sources) {
                File sourceFile = new File(source);
                if (!sourceFile.exists()) continue;
                PdfDocument sourcePdf = new PdfDocument(new PdfReader(source));
                merger.merge(sourcePdf, 1, sourcePdf.getNumberOfPages()).setCloseSourceDocuments(true);
                sourcePdf.close();
            }
            merger.close();
            mergedDoc.close();
            result = true;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    private static PdfDocument setPdfDocument(PdfWriter pdfWriter, PdfSetting pdfSetting) {
        PdfDocument pdfDocument = new PdfDocument(pdfWriter);
        pdfDocument.setDefaultPageSize(pdfSetting.getPageSize());
        if (pdfSetting.getWaterMark() != null && !"".equals(pdfSetting.getWaterMark())) {
            pdfDocument.addEventHandler("EndPdfPage", (IEventHandler)new WaterMarkEventHandler(pdfSetting.getWaterMark()));
        }
        if (pdfSetting.getHeader() != null) {
            pdfDocument.addEventHandler("EndPdfPage", (IEventHandler)new HeaderEventHandler(pdfSetting.getHeader()));
        }
        if (pdfSetting.getFooter() != null) {
            pdfDocument.addEventHandler("EndPdfPage", (IEventHandler)new FooterEventHandler(pdfSetting.getFooter()));
        }
        return pdfDocument;
    }

    private static ConverterProperties setConverterProperties(PdfSetting pdfSetting) {
        ConverterProperties properties = new ConverterProperties();
        FontProvider fontProvider = new FontProvider();
        try {
            if (pdfSetting.getFontPath() != null && !"".equals(pdfSetting.getFontPath())) {
                PdfFont m2 = PdfFontFactory.createFont((String)pdfSetting.getFontPath(), (String)"Identity-H");
                fontProvider.addFont(m2.getFontProgram(), "Identity-H");
            } else if (pdfSetting.getFonts() != null && !pdfSetting.getFonts().isEmpty()) {
                for (FontSetting u : pdfSetting.getFonts()) {
                    PdfFont sysFont = PdfFontFactory.createFont((String)u.getFontProgram(), (String)u.getEncoding(), (PdfFontFactory.EmbeddingStrategy)u.getEmbeddingStrategy(), (boolean)u.getCached());
                    fontProvider.addFont(sysFont.getFontProgram(), u.getEncoding());
                }
            } else {
                PdfFont sysFont = PdfFontFactory.createFont((String)"STSongStd-Light", (String)"UniGB-UCS2-H");
                fontProvider.addFont(sysFont.getFontProgram(), "UniGB-UCS2-H");
                PdfFont m2 = PdfFontFactory.createFont((String)"/fonts/AlibabaPuHuiTi-2-85-Bold.ttf", (String)"Identity-H");
                fontProvider.addFont(m2.getFontProgram(), "Identity-H");
            }
            properties.setFontProvider(fontProvider);
        }
        catch (IOException e) {
            throw new PdfConvertException("[RS-PDF]SetConverterProperties failed:{}", e.getMessage());
        }
        return properties;
    }

    private static InputStream readInputStream(InputStream inputStream) {
        String regExSpecial = "\\&[a-zA-Z]{1,10};";
        try {
            ByteArrayOutputStream bao = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            int len = -1;
            while ((len = inputStream.read(buffer)) != -1) {
                bao.write(buffer, 0, len);
            }
            String content = bao.toString();
            bao.close();
            Pattern compile = Pattern.compile(regExSpecial, 2);
            Matcher matcher = compile.matcher(content);
            String replaceAll = matcher.replaceAll("");
            InputStream stringStream = RsPdf.getStringStream(replaceAll);
            return stringStream;
        }
        catch (Exception e) {
            throw new PdfConvertException("[RS-PDF]Pdf failed:{}", e.getMessage());
        }
    }

    private static InputStream getStringStream(String sInputString) {
        if (sInputString != null && !"".equals(sInputString.trim())) {
            try {
                ByteArrayInputStream tInputStringStream = new ByteArrayInputStream(sInputString.getBytes());
                return tInputStringStream;
            }
            catch (Exception e) {
                throw new PdfConvertException("[RS-PDF]Pdf file generation failed:{}", e.getMessage());
            }
        }
        return null;
    }

    private static String readHtmlFile(String path) {
        File file = new File(path);
        return RsPdf.readHtmlFile(file);
    }

    private static String readHtmlFile(File file) {
        StringBuffer textHtml = new StringBuffer();
        try {
            String tempString;
            BufferedReader reader = new BufferedReader(new FileReader(file));
            while ((tempString = reader.readLine()) != null) {
                textHtml.append(tempString);
            }
            reader.close();
        }
        catch (IOException e) {
            throw new PdfConvertException("[RS-PDF]Source file reading HTML file content:{}", e.getMessage());
        }
        return textHtml.toString();
    }
}

