/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.pdf.event;

import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.colors.DeviceRgb;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.font.PdfFontFactory;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.kernel.pdf.event.AbstractPdfDocumentEvent;
import com.itextpdf.kernel.pdf.event.AbstractPdfDocumentEventHandler;
import com.itextpdf.kernel.pdf.event.PdfDocumentEvent;
import com.itextpdf.layout.Canvas;
import com.itextpdf.layout.borders.Border;
import com.itextpdf.layout.borders.SolidBorder;
import com.itextpdf.layout.element.Paragraph;
import com.itextpdf.layout.properties.TextAlignment;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import top.redscorpion.core.util.RsString;
import top.redscorpion.pdf.HeaderSetting;
import top.redscorpion.pdf.InternalPdfUtil;

public class HeaderEventHandler
extends AbstractPdfDocumentEventHandler {
    private HeaderSetting header;

    private HeaderEventHandler() {
        throw new IllegalStateException("Utility class");
    }

    public HeaderEventHandler(HeaderSetting headerSetting) {
        this.header = headerSetting;
    }

    public void onAcceptedEvent(AbstractPdfDocumentEvent event) {
        PdfDocumentEvent docEvent = (PdfDocumentEvent)event;
        PdfDocument pdf = docEvent.getDocument();
        PdfPage page = docEvent.getPage();
        int pageNumber = pdf.getPageNumber(page);
        PdfFont pdfFont = null;
        try {
            pdfFont = PdfFontFactory.createFont((String)"STSongStd-Light", (String)"UniGB-UCS2-H");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        List<Integer> integerList = Arrays.asList(this.header.getExcludePages());
        if (!integerList.contains(pageNumber)) {
            Paragraph p;
            float x;
            Rectangle pageSize = page.getPageSize();
            PdfCanvas pdfCanvas = new PdfCanvas(page.getLastContentStream(), page.getResources(), pdf);
            Canvas canvas = new Canvas(pdfCanvas, pageSize);
            float y = pageSize.getTop() - 25.0f;
            if (RsString.isNotBlank((CharSequence)this.header.getTextLeft())) {
                x = pageSize.getLeft();
                p = (Paragraph)((Paragraph)new Paragraph(InternalPdfUtil.format(this.header.getTextLeft(), pageNumber, pdf.getNumberOfPages())).setFontSize(this.header.getFontSize())).setFont(pdfFont);
                p.setPaddingLeft(this.header.getMargin());
                canvas.showTextAligned(p, x, y, TextAlignment.LEFT);
            }
            if (RsString.isNotBlank((CharSequence)this.header.getTextCenter())) {
                x = (pageSize.getLeft() + pageSize.getRight()) / 2.0f;
                p = (Paragraph)((Paragraph)new Paragraph(InternalPdfUtil.format(this.header.getTextCenter(), pageNumber, pdf.getNumberOfPages())).setFontSize(this.header.getFontSize())).setFont(pdfFont);
                canvas.showTextAligned(p, x, y, TextAlignment.CENTER);
            }
            if (RsString.isNotBlank((CharSequence)this.header.getTextRight())) {
                x = pageSize.getRight();
                p = (Paragraph)((Paragraph)new Paragraph(InternalPdfUtil.format(this.header.getTextRight(), pageNumber, pdf.getNumberOfPages())).setFontSize(this.header.getFontSize())).setFont(pdfFont);
                p.setPaddingRight(this.header.getMargin());
                canvas.showTextAligned(p, x, y, TextAlignment.RIGHT);
            }
            if (this.header.isLineBottom()) {
                x = pageSize.getLeft();
                float y1 = pageSize.getTop() - 30.0f;
                Paragraph p2 = new Paragraph();
                p2.setHeight(1.0f);
                p2.setBorderBottom((Border)new SolidBorder((Color)new DeviceRgb(120, 120, 120), 0.7f));
                canvas.showTextAligned(p2, x, y1, TextAlignment.LEFT);
            }
            canvas.close();
        }
    }
}

