/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.pdf.event;

import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.colors.WebColors;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.font.PdfFontFactory;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.kernel.pdf.event.AbstractPdfDocumentEvent;
import com.itextpdf.kernel.pdf.event.AbstractPdfDocumentEventHandler;
import com.itextpdf.kernel.pdf.event.PdfDocumentEvent;
import com.itextpdf.layout.Canvas;
import com.itextpdf.layout.element.Paragraph;
import com.itextpdf.layout.properties.TextAlignment;
import com.itextpdf.layout.properties.VerticalAlignment;
import java.io.IOException;

public class WaterMarkEventHandler
extends AbstractPdfDocumentEventHandler {
    private String waterMarkContent;
    private int waterMarkX;
    private int waterMarkY;

    public WaterMarkEventHandler(String waterMarkContent) {
        this(waterMarkContent, 5, 5);
    }

    public WaterMarkEventHandler(String waterMarkContent, int waterMarkX, int waterMarkY) {
        this.waterMarkContent = waterMarkContent;
        this.waterMarkX = waterMarkX;
        this.waterMarkY = waterMarkY;
    }

    public void onAcceptedEvent(AbstractPdfDocumentEvent event) {
        PdfDocumentEvent documentEvent = (PdfDocumentEvent)event;
        PdfDocument document = documentEvent.getDocument();
        PdfPage page = documentEvent.getPage();
        Rectangle pageSize = page.getPageSize();
        PdfFont pdfFont = null;
        try {
            pdfFont = PdfFontFactory.createFont((String)"STSongStd-Light", (String)"UniGB-UCS2-H");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        PdfCanvas pdfCanvas = new PdfCanvas(page.newContentStreamAfter(), page.getResources(), document);
        Paragraph waterMark = (Paragraph)new Paragraph(this.waterMarkContent).setOpacity(Float.valueOf(0.5f));
        Canvas canvas = (Canvas)((Canvas)((Canvas)new Canvas(pdfCanvas, pageSize).setFontColor((Color)WebColors.getRGBColor((String)"lightgray"))).setFontSize(16.0f)).setFont(pdfFont);
        for (int i = 0; i < this.waterMarkX; ++i) {
            for (int j = 0; j < this.waterMarkY; ++j) {
                canvas.showTextAligned(waterMark, (float)(150 + i * 300), (float)(160 + j * 150), document.getNumberOfPages(), TextAlignment.CENTER, VerticalAlignment.BOTTOM, 120.0f);
            }
        }
        canvas.close();
    }
}

