/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.pdf.event;

import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.colors.DeviceRgb;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.font.PdfFontFactory;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.kernel.pdf.event.AbstractPdfDocumentEvent;
import com.itextpdf.kernel.pdf.event.AbstractPdfDocumentEventHandler;
import com.itextpdf.kernel.pdf.event.PdfDocumentEvent;
import com.itextpdf.layout.Canvas;
import com.itextpdf.layout.borders.Border;
import com.itextpdf.layout.borders.SolidBorder;
import com.itextpdf.layout.element.Paragraph;
import com.itextpdf.layout.properties.TextAlignment;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import top.redscorpion.core.util.RsString;
import top.redscorpion.pdf.FooterSetting;
import top.redscorpion.pdf.InternalPdfUtil;

public class FooterEventHandler
extends AbstractPdfDocumentEventHandler {
    private FooterSetting footer;

    private FooterEventHandler() {
        throw new IllegalStateException("Utility class");
    }

    public FooterEventHandler(FooterSetting footerSetting) {
        this.footer = footerSetting;
    }

    public void onAcceptedEvent(AbstractPdfDocumentEvent event) {
        PdfDocumentEvent docEvent = (PdfDocumentEvent)event;
        PdfDocument pdf = docEvent.getDocument();
        PdfPage page = docEvent.getPage();
        int pageNumber = pdf.getPageNumber(page);
        PdfFont pdfFont = null;
        try {
            pdfFont = PdfFontFactory.createFont((String)"STSongStd-Light", (String)"UniGB-UCS2-H");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        List<Integer> integerList = Arrays.asList(this.footer.getExcludePages());
        if (!integerList.contains(pageNumber)) {
            float x;
            Rectangle pageSize = page.getPageSize();
            PdfCanvas pdfCanvas = new PdfCanvas(page.getLastContentStream(), page.getResources(), pdf);
            Canvas canvas = new Canvas(pdfCanvas, pageSize);
            float y = pageSize.getBottom() + 15.0f;
            if (this.footer.isLineTop()) {
                x = pageSize.getLeft();
                float y1 = pageSize.getBottom() + 29.0f;
                Paragraph p = new Paragraph();
                p.setHeight(1.0f);
                p.setBorderBottom((Border)new SolidBorder((Color)new DeviceRgb(120, 120, 120), 0.7f));
                canvas.showTextAligned(p, x, y1, TextAlignment.LEFT);
            }
            if (RsString.isNotBlank((CharSequence)this.footer.getTextLeft())) {
                x = pageSize.getLeft();
                Paragraph p = (Paragraph)((Paragraph)new Paragraph(InternalPdfUtil.format(this.footer.getTextLeft(), pageNumber, pdf.getNumberOfPages())).setFontSize(this.footer.getFontSize())).setFont(pdfFont);
                p.setPaddingLeft(this.footer.getMargin());
                canvas.showTextAligned(p, x, y, TextAlignment.LEFT);
            }
            if (RsString.isNotBlank((CharSequence)this.footer.getTextCenter())) {
                x = (pageSize.getLeft() + pageSize.getRight()) / 2.0f;
                Paragraph p = (Paragraph)((Paragraph)new Paragraph(InternalPdfUtil.format(this.footer.getTextCenter(), pageNumber, pdf.getNumberOfPages())).setFontSize(this.footer.getFontSize())).setFont(pdfFont);
                canvas.showTextAligned(p, x, y, TextAlignment.CENTER);
            }
            if (RsString.isNotBlank((CharSequence)this.footer.getTextRight())) {
                x = pageSize.getRight();
                Paragraph p = (Paragraph)((Paragraph)new Paragraph(InternalPdfUtil.format(this.footer.getTextRight(), pageNumber, pdf.getNumberOfPages())).setFontSize(this.footer.getFontSize())).setFont(pdfFont);
                p.setPaddingRight(this.footer.getMargin());
                canvas.showTextAligned(p, x, y, TextAlignment.RIGHT);
            }
            canvas.close();
        }
    }
}

