/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.poi.excel.sax;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.eventusermodel.EventWorkbookBuilder;
import org.apache.poi.hssf.eventusermodel.FormatTrackingHSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFEventFactory;
import org.apache.poi.hssf.eventusermodel.HSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFRequest;
import org.apache.poi.hssf.eventusermodel.MissingRecordAwareHSSFListener;
import org.apache.poi.hssf.eventusermodel.dummyrecord.LastCellOfRowDummyRecord;
import org.apache.poi.hssf.eventusermodel.dummyrecord.MissingCellDummyRecord;
import org.apache.poi.hssf.record.BOFRecord;
import org.apache.poi.hssf.record.BlankRecord;
import org.apache.poi.hssf.record.BoolErrRecord;
import org.apache.poi.hssf.record.BoundSheetRecord;
import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.hssf.record.EOFRecord;
import org.apache.poi.hssf.record.FormulaRecord;
import org.apache.poi.hssf.record.LabelRecord;
import org.apache.poi.hssf.record.LabelSSTRecord;
import org.apache.poi.hssf.record.NumberRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.SSTRecord;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.util.RsIo;
import top.redscorpion.core.util.RsObject;
import top.redscorpion.core.util.RsString;
import top.redscorpion.poi.excel.sax.ExcelSaxReader;
import top.redscorpion.poi.excel.sax.ExcelSaxUtil;
import top.redscorpion.poi.excel.sax.handler.RowHandler;
import top.redscorpion.poi.exception.POIException;

public class Excel03SaxReader
implements HSSFListener,
ExcelSaxReader<Excel03SaxReader> {
    private final boolean isOutputFormulaValues = true;
    private EventWorkbookBuilder.SheetRecordCollectingListener workbookBuildingListener;
    private HSSFWorkbook stubWorkbook;
    private SSTRecord sstRecord;
    private FormatTrackingHSSFListener formatListener;
    private final List<BoundSheetRecord> boundSheetRecords = new ArrayList<BoundSheetRecord>();
    private boolean isOutputNextStringRecord;
    private List<Object> rowCellList = new ArrayList<Object>();
    private int rid = -1;
    private String sheetName;
    private int curRid = -1;
    private final RowHandler rowHandler;

    public Excel03SaxReader(RowHandler rowHandler) {
        this.rowHandler = rowHandler;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Excel03SaxReader read(File file, String idOrRidOrSheetName) throws POIException {
        try (POIFSFileSystem poifsFileSystem = new POIFSFileSystem(file, true);){
            Excel03SaxReader excel03SaxReader = this.read(poifsFileSystem, idOrRidOrSheetName);
            return excel03SaxReader;
        }
        catch (IOException e) {
            throw new POIException(e);
        }
    }

    @Override
    public Excel03SaxReader read(InputStream excelStream, String idOrRidOrSheetName) throws POIException {
        try {
            return this.read(new POIFSFileSystem(excelStream), idOrRidOrSheetName);
        }
        catch (IOException e) {
            throw new POIException(e);
        }
    }

    public Excel03SaxReader read(POIFSFileSystem fs, String idOrRidOrSheetName) throws POIException {
        this.rid = this.getSheetIndex(idOrRidOrSheetName);
        this.formatListener = new FormatTrackingHSSFListener((HSSFListener)new MissingRecordAwareHSSFListener((HSSFListener)this));
        HSSFRequest request = new HSSFRequest();
        request.addListenerForAllRecords((HSSFListener)this.formatListener);
        HSSFEventFactory factory = new HSSFEventFactory();
        try {
            factory.processWorkbookEvents(request, fs);
        }
        catch (IOException e) {
            try {
                throw new POIException(e);
            }
            catch (Throwable throwable) {
                RsIo.closeQuietly((AutoCloseable[])new AutoCloseable[]{fs});
                throw throwable;
            }
        }
        RsIo.closeQuietly((AutoCloseable[])new AutoCloseable[]{fs});
        return this;
    }

    public int getSheetIndex() {
        return this.rid;
    }

    public String getSheetName() {
        if (null != this.sheetName) {
            return this.sheetName;
        }
        if (this.boundSheetRecords.size() > this.rid) {
            return this.boundSheetRecords.get(this.rid > -1 ? this.rid : this.curRid).getSheetname();
        }
        return null;
    }

    public void processRecord(Record record) {
        if (this.rid > -1 && this.curRid > this.rid) {
            return;
        }
        if (record instanceof BoundSheetRecord) {
            BoundSheetRecord boundSheetRecord = (BoundSheetRecord)record;
            this.boundSheetRecords.add(boundSheetRecord);
            String currentSheetName = boundSheetRecord.getSheetname();
            if (null != this.sheetName && RsString.equals((CharSequence)this.sheetName, (CharSequence)currentSheetName)) {
                this.rid = this.boundSheetRecords.size() - 1;
            }
        } else if (record instanceof SSTRecord) {
            this.sstRecord = (SSTRecord)record;
        } else if (record instanceof BOFRecord) {
            BOFRecord bofRecord = (BOFRecord)record;
            if (bofRecord.getType() == 16) {
                if (this.workbookBuildingListener != null && this.stubWorkbook == null) {
                    this.stubWorkbook = this.workbookBuildingListener.getStubHSSFWorkbook();
                }
                ++this.curRid;
            }
        } else if (record instanceof EOFRecord) {
            if (this.rid < 0 && null != this.sheetName) {
                throw new POIException("Sheet [{}] not exist!", this.sheetName);
            }
            if (this.curRid != -1 && this.isProcessCurrentSheet()) {
                this.processLastCellSheet();
            }
        } else if (this.isProcessCurrentSheet()) {
            if (record instanceof MissingCellDummyRecord) {
                MissingCellDummyRecord mc = (MissingCellDummyRecord)record;
                this.addToRowCellList(mc);
            } else if (record instanceof LastCellOfRowDummyRecord) {
                this.processLastCell((LastCellOfRowDummyRecord)record);
            } else {
                this.processCellValue(record);
            }
        }
    }

    private void addToRowCellList(MissingCellDummyRecord record) {
        this.addToRowCellList(record.getRow(), record.getColumn(), "");
    }

    private void addToRowCellList(CellValueRecordInterface record, Object value) {
        this.addToRowCellList(record.getRow(), record.getColumn(), value);
    }

    private void addToRowCellList(int row, int column, Object value) {
        while (column > this.rowCellList.size()) {
            this.rowCellList.add("");
            this.rowHandler.handleCell(this.curRid, row, this.rowCellList.size() - 1, value, null);
        }
        this.rowCellList.add(column, value);
        this.rowHandler.handleCell(this.curRid, row, column, value, null);
    }

    private void processCellValue(Record record) {
        Object value = null;
        switch (record.getSid()) {
            case 513: {
                this.addToRowCellList((CellValueRecordInterface)((BlankRecord)record), "");
                break;
            }
            case 517: {
                BoolErrRecord berec = (BoolErrRecord)record;
                this.addToRowCellList((CellValueRecordInterface)berec, berec.getBooleanValue());
                break;
            }
            case 6: {
                FormulaRecord formulaRec = (FormulaRecord)record;
                if (Double.isNaN(formulaRec.getValue())) {
                    this.isOutputNextStringRecord = true;
                } else {
                    value = ExcelSaxUtil.getNumberOrDateValue((CellValueRecordInterface)formulaRec, formulaRec.getValue(), this.formatListener);
                }
                this.addToRowCellList((CellValueRecordInterface)formulaRec, value);
                break;
            }
            case 519: {
                if (!this.isOutputNextStringRecord) break;
                this.isOutputNextStringRecord = false;
                break;
            }
            case 516: {
                LabelRecord lrec = (LabelRecord)record;
                value = lrec.getValue();
                this.addToRowCellList((CellValueRecordInterface)lrec, value);
                break;
            }
            case 253: {
                LabelSSTRecord lsrec = (LabelSSTRecord)record;
                if (null != this.sstRecord) {
                    value = this.sstRecord.getString(lsrec.getSSTIndex()).toString();
                }
                this.addToRowCellList((CellValueRecordInterface)lsrec, RsObject.defaultIfNull((Object)value, (Object)""));
                break;
            }
            case 515: {
                NumberRecord numrec = (NumberRecord)record;
                value = ExcelSaxUtil.getNumberOrDateValue((CellValueRecordInterface)numrec, numrec.getValue(), this.formatListener);
                this.addToRowCellList((CellValueRecordInterface)numrec, value);
                break;
            }
        }
    }

    private void processLastCell(LastCellOfRowDummyRecord lastCell) {
        this.rowHandler.handle(this.curRid, lastCell.getRow(), this.rowCellList);
        this.rowCellList = new ArrayList<Object>(this.rowCellList.size());
    }

    private void processLastCellSheet() {
        this.rowHandler.doAfterAllAnalysed();
    }

    private boolean isProcessCurrentSheet() {
        return this.rid < 0 && null == this.sheetName || this.rid == this.curRid;
    }

    private int getSheetIndex(String idOrRidOrSheetName) {
        Assert.notBlank((CharSequence)idOrRidOrSheetName, (String)"id or rid or sheetName must be not blank!", (Object[])new Object[0]);
        if (RsString.startWith((CharSequence)idOrRidOrSheetName, (CharSequence)"rId", (boolean)true)) {
            return Integer.parseInt(RsString.removePrefix((CharSequence)idOrRidOrSheetName, (CharSequence)"rId", (boolean)true));
        }
        if (RsString.startWith((CharSequence)idOrRidOrSheetName, (CharSequence)"sheetName:", (boolean)true)) {
            this.sheetName = RsString.removePrefix((CharSequence)idOrRidOrSheetName, (CharSequence)"sheetName:", (boolean)true);
        } else {
            try {
                return Integer.parseInt(idOrRidOrSheetName);
            }
            catch (NumberFormatException ignore) {
                this.sheetName = idOrRidOrSheetName;
            }
        }
        return -1;
    }
}

