/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.poi.excel.cell;

import top.redscorpion.core.util.RsRegular;
import top.redscorpion.poi.excel.cell.CellLocation;

public class CellLocationUtil {
    public static String indexToColName(int index) {
        int remainder;
        if (index < 0) {
            return null;
        }
        StringBuilder colName = new StringBuilder();
        do {
            if (colName.length() > 0) {
                --index;
            }
            remainder = index % 26;
            colName.append((char)(remainder + 65));
        } while ((index = (index - remainder) / 26) > 0);
        return colName.reverse().toString();
    }

    public static int colNameToIndex(String colName) {
        char c;
        int length = colName.length();
        int index = -1;
        for (int i = 0; i < length && !Character.isDigit(c = Character.toUpperCase(colName.charAt(i))); ++i) {
            index = (index + 1) * 26 + c - 65;
        }
        return index;
    }

    public static CellLocation toLocation(String locationRef) {
        int x = CellLocationUtil.colNameToIndex(locationRef);
        int y = RsRegular.getFirstNumber((CharSequence)locationRef) - 1;
        return new CellLocation(x, y);
    }
}

