/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.poi.excel.sax.handler;

import java.util.List;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.util.RsBean;
import top.redscorpion.core.util.RsConvert;
import top.redscorpion.core.util.RsIter;
import top.redscorpion.core.util.RsList;
import top.redscorpion.poi.excel.sax.handler.AbstractRowHandler;

public abstract class AbstractBeanRowHandler<T>
extends AbstractRowHandler<T> {
    private final int headerRowIndex;
    List<String> headerList;

    public AbstractBeanRowHandler(int headerRowIndex, int startRowIndex, int endRowIndex, Class<T> clazz) {
        super(startRowIndex, endRowIndex);
        Assert.isTrue((headerRowIndex <= startRowIndex ? 1 : 0) != 0, (String)"Header row must before the start row!", (Object[])new Object[0]);
        this.headerRowIndex = headerRowIndex;
        this.convertFunc = rowList -> RsBean.toBean((Object)RsIter.toMap(this.headerList, (Iterable)rowList), (Class)clazz);
    }

    @Override
    public void handle(int sheetIndex, long rowIndex, List<Object> rowCells) {
        if (rowIndex == (long)this.headerRowIndex) {
            this.headerList = RsList.view((List)RsConvert.toList(String.class, rowCells));
            return;
        }
        super.handle(sheetIndex, rowIndex, rowCells);
    }
}

