/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.poi.excel;

import org.apache.poi.ss.formula.ConditionalFormattingEvaluator;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.ExcelNumberFormat;
import top.redscorpion.core.util.RsArray;
import top.redscorpion.core.util.RsString;

public class ExcelDateUtil {
    private static final int[] CUSTOM_FORMATS = new int[]{28, 30, 31, 32, 33, 55, 56, 57, 58};

    public static boolean isDateFormat(Cell cell) {
        return ExcelDateUtil.isDateFormat(cell, null);
    }

    public static boolean isDateFormat(Cell cell, ConditionalFormattingEvaluator cfEvaluator) {
        ExcelNumberFormat nf = ExcelNumberFormat.from((Cell)cell, (ConditionalFormattingEvaluator)cfEvaluator);
        return ExcelDateUtil.isDateFormat(nf);
    }

    public static boolean isDateFormat(ExcelNumberFormat numFmt) {
        return ExcelDateUtil.isDateFormat(numFmt.getIdx(), numFmt.getFormat());
    }

    public static boolean isDateFormat(int formatIndex, String formatString) {
        if (RsArray.contains((int[])CUSTOM_FORMATS, (int)formatIndex)) {
            return true;
        }
        if (RsString.isNotEmpty((CharSequence)formatString) && RsString.containsAny((CharSequence)formatString, (CharSequence[])new CharSequence[]{"\u5468", "\u661f\u671f", "aa"})) {
            return true;
        }
        return DateUtil.isADateFormat((int)formatIndex, (String)formatString);
    }
}

