/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.poi.excel;

import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.extractor.ExcelExtractor;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import top.redscorpion.core.func.SerBiConsumer;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.util.RsFile;
import top.redscorpion.core.util.RsIo;
import top.redscorpion.poi.excel.ExcelBase;
import top.redscorpion.poi.excel.ExcelWriter;
import top.redscorpion.poi.excel.RsExcel;
import top.redscorpion.poi.excel.RsExcelExtractor;
import top.redscorpion.poi.excel.RsRow;
import top.redscorpion.poi.excel.RsWorkbook;
import top.redscorpion.poi.excel.cell.CellEditor;
import top.redscorpion.poi.excel.cell.RsCell;
import top.redscorpion.poi.excel.reader.BeanSheetReader;
import top.redscorpion.poi.excel.reader.ColumnSheetReader;
import top.redscorpion.poi.excel.reader.ListSheetReader;
import top.redscorpion.poi.excel.reader.MapSheetReader;
import top.redscorpion.poi.excel.reader.SheetReader;

public class ExcelReader
extends ExcelBase<ExcelReader> {
    private boolean ignoreEmptyRow = true;
    private CellEditor cellEditor;

    public ExcelReader(String excelFilePath, int sheetIndex) {
        this(RsFile.file((String)excelFilePath), sheetIndex);
    }

    public ExcelReader(String excelFilePath, String sheetName) {
        this(RsFile.file((String)excelFilePath), sheetName);
    }

    public ExcelReader(File bookFile, int sheetIndex) {
        this(RsWorkbook.createBook(bookFile, true), sheetIndex);
        this.destFile = bookFile;
    }

    public ExcelReader(File bookFile, String sheetName) {
        this(RsWorkbook.createBook(bookFile, true), sheetName);
        this.destFile = bookFile;
    }

    public ExcelReader(InputStream bookStream, int sheetIndex) {
        this(RsWorkbook.createBook(bookStream), sheetIndex);
    }

    public ExcelReader(InputStream bookStream, String sheetName) {
        this(RsWorkbook.createBook(bookStream), sheetName);
    }

    public ExcelReader(Workbook book, int sheetIndex) {
        this(ExcelReader.getSheetOrCloseWorkbook(book, sheetIndex));
    }

    public ExcelReader(Workbook book, String sheetName) {
        this(ExcelReader.getSheetOrCloseWorkbook(book, sheetName));
    }

    public ExcelReader(Sheet sheet) {
        super(sheet);
    }

    public boolean isIgnoreEmptyRow() {
        return this.ignoreEmptyRow;
    }

    public ExcelReader setIgnoreEmptyRow(boolean ignoreEmptyRow) {
        this.ignoreEmptyRow = ignoreEmptyRow;
        return this;
    }

    public ExcelReader setCellEditor(CellEditor cellEditor) {
        this.cellEditor = cellEditor;
        return this;
    }

    public List<List<Object>> read() {
        return this.read(0);
    }

    public List<List<Object>> read(int startRowIndex) {
        return this.read(startRowIndex, Integer.MAX_VALUE);
    }

    public List<List<Object>> read(int startRowIndex, int endRowIndex) {
        return this.read(startRowIndex, endRowIndex, false);
    }

    public List<List<Object>> read(int startRowIndex, int endRowIndex, boolean aliasFirstLine) {
        ListSheetReader reader = new ListSheetReader(startRowIndex, endRowIndex, aliasFirstLine);
        reader.setCellEditor(this.cellEditor);
        reader.setIgnoreEmptyRow(this.ignoreEmptyRow);
        reader.setHeaderAlias(this.headerAlias);
        return this.read(reader);
    }

    public List<Object> readColumn(int columnIndex, int startRowIndex) {
        return this.readColumn(columnIndex, startRowIndex, Integer.MAX_VALUE);
    }

    public List<Object> readColumn(int columnIndex, int startRowIndex, int endRowIndex) {
        ColumnSheetReader reader = new ColumnSheetReader(columnIndex, startRowIndex, endRowIndex);
        reader.setCellEditor(this.cellEditor);
        reader.setIgnoreEmptyRow(this.ignoreEmptyRow);
        reader.setHeaderAlias(this.headerAlias);
        return this.read(reader);
    }

    public void read(SerBiConsumer<Cell, Object> cellHandler) {
        this.read(0, Integer.MAX_VALUE, cellHandler);
    }

    public void read(int startRowIndex, int endRowIndex, SerBiConsumer<Cell, Object> cellHandler) {
        this.checkNotClosed();
        startRowIndex = Math.max(startRowIndex, this.sheet.getFirstRowNum());
        endRowIndex = Math.min(endRowIndex, this.sheet.getLastRowNum());
        for (int y = startRowIndex; y <= endRowIndex; ++y) {
            Row row = this.sheet.getRow(y);
            if (null == row) continue;
            short columnSize = row.getLastCellNum();
            for (short x = 0; x < columnSize; x = (short)(x + 1)) {
                Cell cell = row.getCell((int)x);
                cellHandler.accept((Object)cell, RsCell.getCellValue(cell));
            }
        }
    }

    public List<Map<String, Object>> readAll() {
        return this.read(0, 1, Integer.MAX_VALUE);
    }

    public List<Map<String, Object>> read(int headerRowIndex, int startRowIndex, int endRowIndex) {
        MapSheetReader reader = new MapSheetReader(headerRowIndex, startRowIndex, endRowIndex);
        reader.setCellEditor(this.cellEditor);
        reader.setIgnoreEmptyRow(this.ignoreEmptyRow);
        reader.setHeaderAlias(this.headerAlias);
        return this.read(reader);
    }

    public <T> List<T> readAll(Class<T> beanType) {
        return this.read(0, 1, Integer.MAX_VALUE, beanType);
    }

    public <T> List<T> read(int headerRowIndex, int startRowIndex, Class<T> beanType) {
        return this.read(headerRowIndex, startRowIndex, Integer.MAX_VALUE, beanType);
    }

    public <T> List<T> read(int headerRowIndex, int startRowIndex, int endRowIndex, Class<T> beanType) {
        BeanSheetReader<T> reader = new BeanSheetReader<T>(headerRowIndex, startRowIndex, endRowIndex, beanType);
        reader.setCellEditor(this.cellEditor);
        reader.setIgnoreEmptyRow(this.ignoreEmptyRow);
        reader.setHeaderAlias(this.headerAlias);
        return (List)this.read(reader);
    }

    public <T> T read(SheetReader<T> sheetReader) {
        this.checkNotClosed();
        return ((SheetReader)Assert.notNull(sheetReader)).read(this.sheet);
    }

    public String readAsText(boolean withSheetName) {
        return RsExcelExtractor.readAsText(this.workbook, withSheetName);
    }

    public ExcelExtractor getExtractor() {
        return RsExcelExtractor.getExtractor(this.workbook);
    }

    public List<Object> readRow(int rowIndex) {
        return this.readRow(this.sheet.getRow(rowIndex));
    }

    public Object readCellValue(int x, int y) {
        return RsCell.getCellValue(this.getCell(x, y), this.cellEditor);
    }

    public ExcelWriter getWriter() {
        if (null == this.destFile) {
            return new ExcelWriter(this.sheet);
        }
        return RsExcel.getWriter(this.destFile, this.sheet.getSheetName());
    }

    private List<Object> readRow(Row row) {
        return RsRow.readRow(row, this.cellEditor);
    }

    private void checkNotClosed() {
        Assert.isFalse((boolean)this.isClosed, (String)"ExcelReader has been closed!", (Object[])new Object[0]);
    }

    private static Sheet getSheetOrCloseWorkbook(Workbook workbook, String name) throws IllegalArgumentException {
        Sheet sheet;
        Assert.notNull((Object)workbook);
        if (null == name) {
            name = "sheet1";
        }
        if (null == (sheet = workbook.getSheet(name))) {
            RsIo.closeQuietly((AutoCloseable[])new AutoCloseable[]{workbook});
            throw new IllegalArgumentException("Sheet [" + name + "] not exist!");
        }
        return sheet;
    }

    private static Sheet getSheetOrCloseWorkbook(Workbook workbook, int sheetIndex) throws IllegalArgumentException {
        Sheet sheet;
        Assert.notNull((Object)workbook);
        try {
            sheet = workbook.getSheetAt(sheetIndex);
        }
        catch (IllegalArgumentException e) {
            RsIo.closeQuietly((AutoCloseable[])new AutoCloseable[]{workbook});
            throw e;
        }
        if (null == sheet) {
            RsIo.closeQuietly((AutoCloseable[])new AutoCloseable[]{workbook});
            throw new IllegalArgumentException("Sheet at [" + sheetIndex + "] not exist!");
        }
        return sheet;
    }
}

