/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.poi.excel.cell;

import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.ss.util.RegionUtil;
import org.apache.poi.ss.util.SheetUtil;
import top.redscorpion.core.util.RsObject;
import top.redscorpion.poi.excel.cell.CellEditor;
import top.redscorpion.poi.excel.cell.NullCell;
import top.redscorpion.poi.excel.cell.editors.TrimEditor;
import top.redscorpion.poi.excel.cell.setters.CellSetterFactory;
import top.redscorpion.poi.excel.cell.values.CompositeCellValue;
import top.redscorpion.poi.excel.style.StyleSet;

public class RsCell {
    public static Object getCellValue(Cell cell) {
        return RsCell.getCellValue(cell, false);
    }

    public static Object getCellValue(Cell cell, boolean isTrimCellValue) {
        if (null == cell) {
            return null;
        }
        return RsCell.getCellValue(cell, cell.getCellType(), isTrimCellValue);
    }

    public static Object getCellValue(Cell cell, CellEditor cellEditor) {
        return RsCell.getCellValue(cell, null, cellEditor);
    }

    public static Object getCellValue(Cell cell, CellType cellType, boolean isTrimCellValue) {
        return RsCell.getCellValue(cell, cellType, isTrimCellValue ? new TrimEditor() : null);
    }

    public static Object getCellValue(Cell cell, CellType cellType, CellEditor cellEditor) {
        return CompositeCellValue.of(cell, cellType, cellEditor).getValue();
    }

    public static void setCellValue(Cell cell, Object value, StyleSet styleSet, boolean isHeader, CellEditor cellEditor) {
        if (null == cell) {
            return;
        }
        CellStyle cellStyle = null;
        if (null != styleSet) {
            cellStyle = styleSet.getStyleFor(new CellReference(cell), value, isHeader);
        }
        RsCell.setCellValue(cell, value, cellStyle, cellEditor);
    }

    public static void setCellValue(Cell cell, Object value, CellStyle style, CellEditor cellEditor) {
        cell.setCellStyle(style);
        RsCell.setCellValue(cell, value, cellEditor);
    }

    public static void setCellValue(Cell cell, Object value, CellEditor cellEditor) {
        if (null == cell) {
            return;
        }
        if (null != cellEditor) {
            value = cellEditor.edit(cell, value);
        }
        RsCell.setCellValue(cell, value);
    }

    public static void setCellValue(Cell cell, Object value) {
        if (null == cell) {
            return;
        }
        if (CellType.BLANK != cell.getCellType()) {
            cell.setBlank();
        }
        CellSetterFactory.createCellSetter(value).setValue(cell);
    }

    public static Cell getCell(Row row, int cellIndex) {
        if (null == row) {
            return null;
        }
        Cell cell = row.getCell(cellIndex);
        if (null == cell) {
            return new NullCell(row, cellIndex);
        }
        return cell;
    }

    public static Cell getOrCreateCell(Row row, int cellIndex) {
        if (null == row) {
            return null;
        }
        Cell cell = row.getCell(cellIndex);
        if (null == cell) {
            cell = row.createCell(cellIndex);
        }
        return cell;
    }

    public static boolean isMergedRegion(Sheet sheet, String locationRef) {
        CellReference cellReference = new CellReference(locationRef);
        return RsCell.isMergedRegion(sheet, cellReference.getCol(), cellReference.getRow());
    }

    public static boolean isMergedRegion(Cell cell) {
        return RsCell.isMergedRegion(cell.getSheet(), cell.getColumnIndex(), cell.getRowIndex());
    }

    public static boolean isMergedRegion(Sheet sheet, int x, int y) {
        int sheetMergeCount = sheet.getNumMergedRegions();
        for (int i = 0; i < sheetMergeCount; ++i) {
            CellRangeAddress ca = sheet.getMergedRegion(i);
            if (y < ca.getFirstRow() || y > ca.getLastRow() || x < ca.getFirstColumn() || x > ca.getLastColumn()) continue;
            return true;
        }
        return false;
    }

    public static int mergingCells(Sheet sheet, CellRangeAddress cellRangeAddress) {
        return RsCell.mergingCells(sheet, cellRangeAddress, null);
    }

    public static int mergingCells(Sheet sheet, CellRangeAddress cellRangeAddress, CellStyle cellStyle) {
        RsCell.setMergeCellStyle(cellStyle, cellRangeAddress, sheet);
        return sheet.addMergedRegion(cellRangeAddress);
    }

    public static Object getMergedRegionValue(Sheet sheet, String locationRef) {
        CellReference cellReference = new CellReference(locationRef);
        return RsCell.getMergedRegionValue(sheet, cellReference.getCol(), cellReference.getRow());
    }

    public static Object getMergedRegionValue(Sheet sheet, int x, int y) {
        return RsCell.getCellValue(SheetUtil.getCell((Sheet)sheet, (int)x, (int)y));
    }

    public static Cell getMergedRegionCell(Cell cell) {
        if (null == cell) {
            return null;
        }
        return (Cell)RsObject.defaultIfNull((Object)RsCell.getCellIfMergedRegion(cell.getSheet(), cell.getColumnIndex(), cell.getRowIndex()), (Object)cell);
    }

    public static Cell getMergedRegionCell(Sheet sheet, int x, int y) {
        return (Cell)RsObject.defaultIfNull((Object)RsCell.getCellIfMergedRegion(sheet, x, y), () -> SheetUtil.getCell((Sheet)sheet, (int)y, (int)x));
    }

    public static void setComment(Cell cell, String commentText, String commentAuthor) {
        RsCell.setComment(cell, commentText, commentAuthor, null);
    }

    public static void setComment(Cell cell, String commentText, String commentAuthor, ClientAnchor anchor) {
        Sheet sheet = cell.getSheet();
        CreationHelper factory = sheet.getWorkbook().getCreationHelper();
        if (anchor == null) {
            anchor = factory.createClientAnchor();
            anchor.setCol1(cell.getColumnIndex() + 1);
            anchor.setCol2(cell.getColumnIndex() + 3);
            anchor.setRow1(cell.getRowIndex());
            anchor.setRow2(cell.getRowIndex() + 2);
            anchor.setAnchorType(ClientAnchor.AnchorType.MOVE_AND_RESIZE);
        }
        Comment comment = sheet.createDrawingPatriarch().createCellComment(anchor);
        comment.setAddress(cell.getAddress());
        comment.setString(factory.createRichTextString(commentText));
        if (null != commentAuthor) {
            comment.setAuthor(commentAuthor);
        }
        cell.setCellComment(comment);
    }

    private static Cell getCellIfMergedRegion(Sheet sheet, int x, int y) {
        for (CellRangeAddress ca : sheet.getMergedRegions()) {
            if (!ca.isInRange(y, x)) continue;
            return SheetUtil.getCell((Sheet)sheet, (int)ca.getFirstRow(), (int)ca.getFirstColumn());
        }
        return null;
    }

    private static void setMergeCellStyle(CellStyle cellStyle, CellRangeAddress cellRangeAddress, Sheet sheet) {
        if (null != cellStyle) {
            RegionUtil.setBorderTop((BorderStyle)cellStyle.getBorderTop(), (CellRangeAddress)cellRangeAddress, (Sheet)sheet);
            RegionUtil.setBorderRight((BorderStyle)cellStyle.getBorderRight(), (CellRangeAddress)cellRangeAddress, (Sheet)sheet);
            RegionUtil.setBorderBottom((BorderStyle)cellStyle.getBorderBottom(), (CellRangeAddress)cellRangeAddress, (Sheet)sheet);
            RegionUtil.setBorderLeft((BorderStyle)cellStyle.getBorderLeft(), (CellRangeAddress)cellRangeAddress, (Sheet)sheet);
            RegionUtil.setTopBorderColor((int)cellStyle.getTopBorderColor(), (CellRangeAddress)cellRangeAddress, (Sheet)sheet);
            RegionUtil.setRightBorderColor((int)cellStyle.getRightBorderColor(), (CellRangeAddress)cellRangeAddress, (Sheet)sheet);
            RegionUtil.setLeftBorderColor((int)cellStyle.getLeftBorderColor(), (CellRangeAddress)cellRangeAddress, (Sheet)sheet);
            RegionUtil.setBottomBorderColor((int)cellStyle.getBottomBorderColor(), (CellRangeAddress)cellRangeAddress, (Sheet)sheet);
        }
    }

    public static void setAutoColumnWidth(Sheet sheet, int size) {
        for (int columnNum = 0; columnNum <= size; ++columnNum) {
            int columnWidth = sheet.getColumnWidth(columnNum) / 256;
            for (int rowNum = 0; rowNum <= sheet.getLastRowNum(); ++rowNum) {
                int length;
                Cell currentCell;
                Row currentRow = sheet.getRow(rowNum) == null ? sheet.createRow(rowNum) : sheet.getRow(rowNum);
                if (currentRow.getCell(columnNum) == null || (currentCell = currentRow.getCell(columnNum)).getCellType() != CellType.STRING || columnWidth >= (length = currentCell.getStringCellValue().getBytes().length)) continue;
                columnWidth = length;
            }
            sheet.setColumnWidth(columnNum, columnWidth * 256 + 300);
        }
    }
}

