/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.poi.excel.reader;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Sheet;
import top.redscorpion.core.util.RsColl;
import top.redscorpion.core.util.RsObject;
import top.redscorpion.poi.excel.RsRow;
import top.redscorpion.poi.excel.cell.CellEditor;
import top.redscorpion.poi.excel.cell.RsCellReference;
import top.redscorpion.poi.excel.reader.SheetReader;

public abstract class AbstractSheetReader<T>
implements SheetReader<T> {
    protected final int startRowIndex;
    protected final int endRowIndex;
    protected boolean ignoreEmptyRow = true;
    protected CellEditor cellEditor;
    private Map<String, String> headerAlias;

    public AbstractSheetReader(int startRowIndex, int endRowIndex) {
        this.startRowIndex = startRowIndex;
        this.endRowIndex = endRowIndex;
    }

    public void setCellEditor(CellEditor cellEditor) {
        this.cellEditor = cellEditor;
    }

    public void setIgnoreEmptyRow(boolean ignoreEmptyRow) {
        this.ignoreEmptyRow = ignoreEmptyRow;
    }

    public void setHeaderAlias(Map<String, String> headerAlias) {
        this.headerAlias = headerAlias;
    }

    public void addHeaderAlias(String header, String alias) {
        Map<String, String> headerAlias = this.headerAlias;
        if (null == headerAlias) {
            headerAlias = new LinkedHashMap<String, String>();
        }
        this.headerAlias = headerAlias;
        this.headerAlias.put(header, alias);
    }

    protected List<String> aliasHeader(List<Object> headerList) {
        if (RsColl.isEmpty(headerList)) {
            return new ArrayList<String>(0);
        }
        int size = headerList.size();
        ArrayList<String> result = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            result.add(this.aliasHeader(headerList.get(i), i));
        }
        return result;
    }

    protected String aliasHeader(Object headerObj, int index) {
        if (null == headerObj) {
            return RsCellReference.indexToColName(index);
        }
        String header = headerObj.toString();
        if (null != this.headerAlias) {
            return (String)RsObject.defaultIfNull((Object)this.headerAlias.get(header), (Object)header);
        }
        return header;
    }

    protected List<Object> readRow(Sheet sheet, int rowIndex) {
        return RsRow.readRow(sheet.getRow(rowIndex), this.cellEditor);
    }
}

