/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.poi.excel.style;

import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import top.redscorpion.core.util.RsObject;
import top.redscorpion.core.util.RsString;
import top.redscorpion.poi.excel.style.CellBorderStyle;

public class RsStyle {
    public static CellStyle createCellStyle(Workbook workbook) {
        if (null == workbook) {
            return null;
        }
        return workbook.createCellStyle();
    }

    public static CellStyle createDefaultCellStyle(Workbook workbook) {
        CellStyle cellStyle = RsStyle.createCellStyle(workbook);
        RsStyle.setAlign(cellStyle, HorizontalAlignment.CENTER, VerticalAlignment.CENTER);
        RsStyle.setBorder(cellStyle, BorderStyle.THIN, IndexedColors.BLACK);
        return cellStyle;
    }

    public static CellStyle createHeadCellStyle(Workbook workbook) {
        CellStyle cellStyle = RsStyle.createCellStyle(workbook);
        RsStyle.setAlign(cellStyle, HorizontalAlignment.CENTER, VerticalAlignment.CENTER);
        RsStyle.setBorder(cellStyle, BorderStyle.THIN, IndexedColors.BLACK);
        RsStyle.setColor(cellStyle, IndexedColors.GREY_25_PERCENT, FillPatternType.SOLID_FOREGROUND);
        return cellStyle;
    }

    public static boolean isNullOrDefaultStyle(Workbook workbook, CellStyle style) {
        return null == style || style.equals(workbook.getCellStyleAt(0));
    }

    public static CellStyle cloneCellStyle(Cell cell, CellStyle cellStyle) {
        return RsStyle.cloneCellStyle(cell.getSheet().getWorkbook(), cellStyle);
    }

    public static CellStyle cloneCellStyle(Workbook workbook, CellStyle cellStyle) {
        CellStyle newCellStyle = RsStyle.createCellStyle(workbook);
        newCellStyle.cloneStyleFrom(cellStyle);
        return newCellStyle;
    }

    public static CellStyle setAlign(CellStyle cellStyle, HorizontalAlignment halign, VerticalAlignment valign) {
        cellStyle.setAlignment(halign);
        cellStyle.setVerticalAlignment(valign);
        return cellStyle;
    }

    public static CellStyle setBorder(CellStyle cellStyle, BorderStyle borderSize, IndexedColors colorIndex) {
        return RsStyle.setBorder(cellStyle, CellBorderStyle.of(borderSize, colorIndex));
    }

    public static CellStyle setBorder(CellStyle cellStyle, CellBorderStyle cellBorderStyle) {
        return cellBorderStyle.setTo(cellStyle);
    }

    public static CellStyle setColor(CellStyle cellStyle, IndexedColors color, FillPatternType fillPattern) {
        return RsStyle.setColor(cellStyle, color.index, fillPattern);
    }

    public static CellStyle setColor(CellStyle cellStyle, short color, FillPatternType fillPattern) {
        cellStyle.setFillForegroundColor(color);
        cellStyle.setFillPattern((FillPatternType)RsObject.defaultIfNull((Object)fillPattern, (Object)FillPatternType.SOLID_FOREGROUND));
        return cellStyle;
    }

    public static CellStyle setColor(XSSFCellStyle cellStyle, XSSFColor color, FillPatternType fillPattern) {
        cellStyle.setFillForegroundColor(color);
        cellStyle.setFillPattern((FillPatternType)RsObject.defaultIfNull((Object)fillPattern, (Object)FillPatternType.SOLID_FOREGROUND));
        return cellStyle;
    }

    public static Font createFont(Workbook workbook, short color, short fontSize, String fontName) {
        Font font = workbook.createFont();
        return RsStyle.setFontStyle(font, color, fontSize, fontName);
    }

    public static Font setFontStyle(Font font, short color, short fontSize, String fontName) {
        if (color > 0) {
            font.setColor(color);
        }
        if (fontSize > 0) {
            font.setFontHeightInPoints(fontSize);
        }
        if (RsString.isNotBlank((CharSequence)fontName)) {
            font.setFontName(fontName);
        }
        return font;
    }

    public static Short getFormat(Workbook workbook, String format) {
        DataFormat dataFormat = workbook.createDataFormat();
        return dataFormat.getFormat(format);
    }
}

