/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.poi.excel;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import top.redscorpion.core.io.IORuntimeException;
import top.redscorpion.core.util.RsFile;
import top.redscorpion.core.util.RsIo;
import top.redscorpion.core.util.RsString;
import top.redscorpion.poi.exception.POIException;

public class RsWorkbook {
    public static Workbook createBook(String excelFilePath) {
        return RsWorkbook.createBook(excelFilePath, false);
    }

    public static Workbook createBook(String excelFilePath, boolean readOnly) {
        return RsWorkbook.createBook(RsFile.file((String)excelFilePath), null, readOnly);
    }

    public static Workbook createBook(File excelFile) {
        return RsWorkbook.createBook(excelFile, false);
    }

    public static Workbook createBook(File excelFile, boolean readOnly) {
        return RsWorkbook.createBook(excelFile, null, readOnly);
    }

    public static Workbook createBookForWriter(File excelFile) {
        if (null == excelFile) {
            return RsWorkbook.createBook(true);
        }
        if (excelFile.exists()) {
            return RsWorkbook.createBook(RsFile.getInputStream((File)excelFile));
        }
        return RsWorkbook.createBook(RsString.endWith((CharSequence)excelFile.getName(), (CharSequence)".xlsx", (boolean)true));
    }

    public static Workbook createBook(File excelFile, String password) {
        return RsWorkbook.createBook(excelFile, password, false);
    }

    public static Workbook createBook(File excelFile, String password, boolean readOnly) {
        try {
            return WorkbookFactory.create((File)excelFile, (String)password, (boolean)readOnly);
        }
        catch (Exception e) {
            throw new POIException(e);
        }
    }

    public static Workbook createBook(InputStream in) {
        return RsWorkbook.createBook(in, null);
    }

    public static Workbook createBook(InputStream in, String password) {
        Workbook workbook;
        try {
            workbook = WorkbookFactory.create((InputStream)RsIo.toMarkSupport((InputStream)in), (String)password);
        }
        catch (Exception e) {
            try {
                throw new POIException(e);
            }
            catch (Throwable throwable) {
                RsIo.closeQuietly((AutoCloseable[])new AutoCloseable[]{in});
                throw throwable;
            }
        }
        RsIo.closeQuietly((AutoCloseable[])new AutoCloseable[]{in});
        return workbook;
    }

    public static Workbook createBook(boolean isXlsx) {
        try {
            return WorkbookFactory.create((boolean)isXlsx);
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
    }

    public static SXSSFWorkbook createSXSSFBook(String excelFilePath) {
        return RsWorkbook.createSXSSFBook(excelFilePath, false);
    }

    public static SXSSFWorkbook createSXSSFBook(String excelFilePath, boolean readOnly) {
        return RsWorkbook.createSXSSFBook(RsFile.file((String)excelFilePath), null, readOnly);
    }

    public static SXSSFWorkbook createSXSSFBook(File excelFile) {
        return RsWorkbook.createSXSSFBook(excelFile, false);
    }

    public static SXSSFWorkbook createSXSSFBook(File excelFile, boolean readOnly) {
        return RsWorkbook.createSXSSFBook(excelFile, null, readOnly);
    }

    public static SXSSFWorkbook createSXSSFBook(File excelFile, String password) {
        return RsWorkbook.createSXSSFBook(excelFile, password, false);
    }

    public static SXSSFWorkbook createSXSSFBook(File excelFile, String password, boolean readOnly) {
        return RsWorkbook.toSXSSFBook(RsWorkbook.createBook(excelFile, password, readOnly));
    }

    public static SXSSFWorkbook createSXSSFBook(InputStream in) {
        return RsWorkbook.createSXSSFBook(in, null);
    }

    public static SXSSFWorkbook createSXSSFBook(InputStream in, String password) {
        return RsWorkbook.toSXSSFBook(RsWorkbook.createBook(in, password));
    }

    public static SXSSFWorkbook createSXSSFBook() {
        return new SXSSFWorkbook();
    }

    public static SXSSFWorkbook createSXSSFBook(int rowAccessWindowSize) {
        return new SXSSFWorkbook(rowAccessWindowSize);
    }

    public static SXSSFWorkbook createSXSSFBook(int rowAccessWindowSize, boolean compressTmpFiles, boolean useSharedStringsTable) {
        return new SXSSFWorkbook(null, rowAccessWindowSize, compressTmpFiles, useSharedStringsTable);
    }

    public static void writeBook(Workbook book, OutputStream out) throws IORuntimeException {
        try {
            book.write(out);
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
    }

    public static Sheet getOrCreateSheet(Workbook book, String sheetName) {
        if (null == book) {
            return null;
        }
        Sheet sheet = book.getSheet(sheetName = RsString.isBlank((CharSequence)sheetName) ? "sheet1" : sheetName);
        if (null == sheet) {
            sheet = book.createSheet(sheetName);
        }
        return sheet;
    }

    public static Sheet getOrCreateSheet(Workbook book, int sheetIndex) {
        Sheet sheet = null;
        try {
            sheet = book.getSheetAt(sheetIndex);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (null == sheet) {
            sheet = book.createSheet();
        }
        return sheet;
    }

    public static boolean isEmpty(Sheet sheet) {
        return null == sheet || sheet.getLastRowNum() == 0 && sheet.getPhysicalNumberOfRows() == 0;
    }

    private static SXSSFWorkbook toSXSSFBook(Workbook book) {
        if (book instanceof SXSSFWorkbook) {
            return (SXSSFWorkbook)book;
        }
        if (book instanceof XSSFWorkbook) {
            return new SXSSFWorkbook((XSSFWorkbook)book);
        }
        throw new POIException("The input is not a [xlsx] format.");
    }
}

