/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.poi.excel.cell.values;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import top.redscorpion.poi.excel.cell.CellEditor;
import top.redscorpion.poi.excel.cell.CellValue;
import top.redscorpion.poi.excel.cell.NullCell;
import top.redscorpion.poi.excel.cell.RsCell;
import top.redscorpion.poi.excel.cell.values.ErrorCellValue;
import top.redscorpion.poi.excel.cell.values.NumericCellValue;

public class CompositeCellValue
implements CellValue<Object> {
    private final Cell cell;
    private final CellType cellType;
    private final CellEditor cellEditor;

    public static CompositeCellValue of(Cell cell, CellType cellType, CellEditor cellEditor) {
        return new CompositeCellValue(cell, cellType, cellEditor);
    }

    public CompositeCellValue(Cell cell, CellType cellType, CellEditor cellEditor) {
        this.cell = cell;
        this.cellType = cellType;
        this.cellEditor = cellEditor;
    }

    @Override
    public Object getValue() {
        Object value;
        Cell mergedCell;
        Cell cell = this.cell;
        CellType cellType = this.cellType;
        CellEditor cellEditor = this.cellEditor;
        if (null == cell) {
            return null;
        }
        if (cell instanceof NullCell) {
            return null == cellEditor ? null : cellEditor.edit(cell, null);
        }
        if (null == cellType) {
            cellType = cell.getCellType();
        }
        if ((mergedCell = RsCell.getMergedRegionCell(cell)) != cell) {
            cell = mergedCell;
            cellType = cell.getCellType();
        }
        switch (cellType) {
            case NUMERIC: {
                value = new NumericCellValue(cell).getValue();
                break;
            }
            case BOOLEAN: {
                value = cell.getBooleanCellValue();
                break;
            }
            case FORMULA: {
                value = CompositeCellValue.of(cell, cell.getCachedFormulaResultType(), cellEditor).getValue();
                break;
            }
            case BLANK: {
                value = "";
                break;
            }
            case ERROR: {
                value = new ErrorCellValue(cell).getValue();
                break;
            }
            default: {
                value = cell.getStringCellValue();
            }
        }
        return null == cellEditor ? value : cellEditor.edit(cell, value);
    }
}

