/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.poi.excel.cell.setters;

import java.io.File;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Sheet;
import top.redscorpion.core.util.RsFile;
import top.redscorpion.poi.excel.ExcelImgType;
import top.redscorpion.poi.excel.RsExcelImg;
import top.redscorpion.poi.excel.SimpleClientAnchor;
import top.redscorpion.poi.excel.cell.setters.CellSetter;
import top.redscorpion.poi.excel.writer.RsExcelDrawing;

public class ImgCellSetter
implements CellSetter {
    private final byte[] pictureData;
    private final ExcelImgType imgType;

    public ImgCellSetter(byte[] pictureData) {
        this(pictureData, ExcelImgType.PNG);
    }

    public ImgCellSetter(File picturefile) {
        this(RsFile.readBytes((File)picturefile), RsExcelImg.getImgType(picturefile));
    }

    public ImgCellSetter(byte[] pictureData, ExcelImgType imgType) {
        this.pictureData = pictureData;
        this.imgType = imgType;
    }

    @Override
    public void setValue(Cell cell) {
        Sheet sheet = cell.getSheet();
        int columnIndex = cell.getColumnIndex();
        int rowIndex = cell.getRowIndex();
        RsExcelDrawing.drawingImg(sheet, this.pictureData, this.imgType, new SimpleClientAnchor(columnIndex, rowIndex, columnIndex + 1, rowIndex + 1));
    }
}

