/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.poi.excel;

import java.io.Closeable;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.common.usermodel.HyperlinkType;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.util.RsIo;
import top.redscorpion.poi.excel.ExcelConfig;
import top.redscorpion.poi.excel.RsRow;
import top.redscorpion.poi.excel.RsSheet;
import top.redscorpion.poi.excel.cell.RsCell;
import top.redscorpion.poi.excel.style.RsStyle;

public class ExcelBase<T extends ExcelBase<T, C>, C extends ExcelConfig>
implements Closeable {
    protected C config;
    protected boolean isClosed;
    protected File targetFile;
    protected Workbook workbook;
    protected Sheet sheet;

    public ExcelBase(C config, Sheet sheet) {
        this.config = (ExcelConfig)Assert.notNull(config);
        this.sheet = (Sheet)Assert.notNull((Object)sheet, (String)"No Sheet provided.", (Object[])new Object[0]);
        this.workbook = sheet.getWorkbook();
    }

    public T setConfig(C config) {
        this.config = config;
        return (T)this;
    }

    public C getConfig() {
        return this.config;
    }

    public Workbook getWorkbook() {
        return this.workbook;
    }

    public int getSheetCount() {
        return this.workbook.getNumberOfSheets();
    }

    public List<Sheet> getSheets() {
        int totalSheet = this.getSheetCount();
        ArrayList<Sheet> result = new ArrayList<Sheet>(totalSheet);
        for (int i = 0; i < totalSheet; ++i) {
            result.add(this.workbook.getSheetAt(i));
        }
        return result;
    }

    public List<String> getSheetNames() {
        int totalSheet = this.workbook.getNumberOfSheets();
        ArrayList<String> result = new ArrayList<String>(totalSheet);
        for (int i = 0; i < totalSheet; ++i) {
            result.add(this.workbook.getSheetAt(i).getSheetName());
        }
        return result;
    }

    public Sheet getSheet() {
        return this.sheet;
    }

    public T renameSheet(String newName) {
        this.workbook.setSheetName(this.workbook.getSheetIndex(this.sheet), newName);
        return (T)this;
    }

    public T setSheet(String sheetName) {
        return this.setSheet(RsSheet.getOrCreateSheet(this.workbook, sheetName));
    }

    public T setSheet(int sheetIndex) {
        return this.setSheet(RsSheet.getOrCreateSheet(this.workbook, sheetIndex));
    }

    public T setSheet(Sheet sheet) {
        this.sheet = sheet;
        return (T)this;
    }

    public T cloneSheet(int sheetIndex, String newSheetName, boolean setAsCurrentSheet) {
        Sheet sheet;
        if (this.workbook instanceof XSSFWorkbook) {
            XSSFWorkbook workbook = (XSSFWorkbook)this.workbook;
            sheet = workbook.cloneSheet(sheetIndex, newSheetName);
        } else {
            sheet = this.workbook.cloneSheet(sheetIndex);
            this.workbook.setSheetName(this.workbook.getSheetIndex(sheet), newSheetName);
        }
        if (setAsCurrentSheet) {
            this.sheet = sheet;
        }
        return (T)this;
    }

    public Cell getCell(String locationRef) {
        CellReference cellReference = new CellReference(locationRef);
        return this.getCell(cellReference.getCol(), cellReference.getRow());
    }

    public Cell getCell(int x, int y) {
        return this.getCell(x, y, false);
    }

    public Cell getOrCreateCell(String locationRef) {
        CellReference cellReference = new CellReference(locationRef);
        return this.getOrCreateCell(cellReference.getCol(), cellReference.getRow());
    }

    public Cell getOrCreateCell(int x, int y) {
        return this.getCell(x, y, true);
    }

    public Cell getCell(String locationRef, boolean isCreateIfNotExist) {
        CellReference cellReference = new CellReference(locationRef);
        return this.getCell(cellReference.getCol(), cellReference.getRow(), isCreateIfNotExist);
    }

    public Cell getCell(int x, int y, boolean isCreateIfNotExist) {
        return RsCell.getCell(this.sheet, x, y, isCreateIfNotExist);
    }

    public Row getOrCreateRow(int y) {
        return RsRow.getOrCreateRow(this.sheet, y);
    }

    public int getRowCount() {
        return this.sheet.getLastRowNum() + 1;
    }

    public int getPhysicalRowCount() {
        return this.sheet.getPhysicalNumberOfRows();
    }

    public CellStyle getOrCreateCellStyle(String locationRef) {
        CellReference cellReference = new CellReference(locationRef);
        return this.getOrCreateCellStyle(cellReference.getCol(), cellReference.getRow());
    }

    public CellStyle getOrCreateCellStyle(int x, int y) {
        CellStyle cellStyle = this.getOrCreateCell(x, y).getCellStyle();
        return RsStyle.isNullOrDefaultStyle(this.workbook, cellStyle) ? this.createCellStyle(x, y) : cellStyle;
    }

    public CellStyle createCellStyle(String locationRef) {
        CellReference cellReference = new CellReference(locationRef);
        return this.createCellStyle(cellReference.getCol(), cellReference.getRow());
    }

    public CellStyle createCellStyle(int x, int y) {
        Cell cell = this.getOrCreateCell(x, y);
        CellStyle cellStyle = this.workbook.createCellStyle();
        cell.setCellStyle(cellStyle);
        return cellStyle;
    }

    public CellStyle createCellStyle() {
        return RsStyle.createCellStyle(this.workbook);
    }

    public CellStyle getOrCreateRowStyle(int y) {
        CellStyle rowStyle = this.getOrCreateRow(y).getRowStyle();
        return RsStyle.isNullOrDefaultStyle(this.workbook, rowStyle) ? this.createRowStyle(y) : rowStyle;
    }

    public CellStyle createRowStyle(int y) {
        CellStyle rowStyle = this.workbook.createCellStyle();
        this.getOrCreateRow(y).setRowStyle(rowStyle);
        return rowStyle;
    }

    public CellStyle getOrCreateColumnStyle(int x) {
        CellStyle columnStyle = this.sheet.getColumnStyle(x);
        return RsStyle.isNullOrDefaultStyle(this.workbook, columnStyle) ? this.createColumnStyle(x) : columnStyle;
    }

    public CellStyle createColumnStyle(int x) {
        CellStyle columnStyle = this.workbook.createCellStyle();
        this.sheet.setDefaultColumnStyle(x, columnStyle);
        return columnStyle;
    }

    public Font createFont() {
        return this.getWorkbook().createFont();
    }

    public Hyperlink createHyperlink(HyperlinkType type, String address) {
        return this.createHyperlink(type, address, address);
    }

    public Hyperlink createHyperlink(HyperlinkType type, String address, String label) {
        Hyperlink hyperlink = this.workbook.getCreationHelper().createHyperlink(type);
        hyperlink.setAddress(address);
        hyperlink.setLabel(label);
        return hyperlink;
    }

    public int getColumnCount() {
        return this.getColumnCount(0);
    }

    public int getColumnCount(int rowNum) {
        Row row = this.sheet.getRow(rowNum);
        if (null != row) {
            return row.getLastCellNum();
        }
        return -1;
    }

    public boolean isXlsx() {
        return this.sheet instanceof XSSFSheet || this.sheet instanceof SXSSFSheet;
    }

    public String getContentType() {
        return this.isXlsx() ? "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet" : "application/vnd.ms-excel";
    }

    @Override
    public void close() {
        RsIo.closeQuietly((AutoCloseable[])new AutoCloseable[]{this.workbook});
        this.sheet = null;
        this.workbook = null;
        this.isClosed = true;
    }

    protected void checkClosed() {
        Assert.isFalse((boolean)this.isClosed, (String)"Excel has been closed!", (Object[])new Object[0]);
    }
}

