/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.poi.excel.writer;

import java.io.File;
import java.io.OutputStream;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import top.redscorpion.core.io.IORuntimeException;
import top.redscorpion.core.util.RsFile;
import top.redscorpion.core.util.RsIo;
import top.redscorpion.poi.excel.RsSheet;
import top.redscorpion.poi.excel.RsWorkbook;
import top.redscorpion.poi.excel.writer.ExcelWriter;

public class BigExcelWriter
extends ExcelWriter {
    public static final int DEFAULT_WINDOW_SIZE = 100;
    private boolean isFlushed;

    public BigExcelWriter() {
        this(100);
    }

    public BigExcelWriter(int rowAccessWindowSize) {
        this(RsWorkbook.createSXSSFBook(rowAccessWindowSize), (String)null);
    }

    public BigExcelWriter(int rowAccessWindowSize, boolean compressTmpFiles, boolean useSharedStringsTable, String sheetName) {
        this(RsWorkbook.createSXSSFBook(rowAccessWindowSize, compressTmpFiles, useSharedStringsTable), sheetName);
    }

    public BigExcelWriter(String destFilePath) {
        this(destFilePath, (String)null);
    }

    public BigExcelWriter(int rowAccessWindowSize, String sheetName) {
        this(RsWorkbook.createSXSSFBook(rowAccessWindowSize), sheetName);
    }

    public BigExcelWriter(String destFilePath, String sheetName) {
        this(RsFile.file((String)destFilePath), sheetName);
    }

    public BigExcelWriter(File destFile) {
        this(destFile, (String)null);
    }

    public BigExcelWriter(File destFile, String sheetName) {
        this(destFile.exists() ? RsWorkbook.createSXSSFBook(destFile) : RsWorkbook.createSXSSFBook(), sheetName);
        this.targetFile = destFile;
    }

    public BigExcelWriter(SXSSFWorkbook workbook, String sheetName) {
        this(RsSheet.getOrCreateSheet((Workbook)workbook, sheetName));
    }

    public BigExcelWriter(Sheet sheet) {
        super(sheet);
    }

    @Override
    public BigExcelWriter autoSizeColumn(int columnIndex, boolean useMergedCells, float widthRatio) {
        SXSSFSheet sheet = (SXSSFSheet)this.sheet;
        sheet.trackColumnForAutoSizing(columnIndex);
        super.autoSizeColumn(columnIndex, useMergedCells, widthRatio);
        sheet.untrackColumnForAutoSizing(columnIndex);
        return this;
    }

    @Override
    public BigExcelWriter autoSizeColumnAll(boolean useMergedCells, float widthRatio) {
        SXSSFSheet sheet = (SXSSFSheet)this.sheet;
        sheet.trackAllColumnsForAutoSizing();
        super.autoSizeColumnAll(useMergedCells, widthRatio);
        sheet.untrackAllColumnsForAutoSizing();
        return this;
    }

    @Override
    public ExcelWriter flush(OutputStream out, boolean isCloseOut) throws IORuntimeException {
        if (!this.isFlushed) {
            this.isFlushed = true;
            return super.flush(out, isCloseOut);
        }
        return this;
    }

    @Override
    public void close() {
        if (null != this.targetFile && !this.isFlushed) {
            this.flush();
        }
        RsIo.closeIfPossible((Object)this.workbook);
        super.closeWithoutFlush();
    }
}

