/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.poi.excel.reader.sheet;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Sheet;
import top.redscorpion.core.bean.copier.CopyOptions;
import top.redscorpion.core.util.RsBean;
import top.redscorpion.poi.excel.reader.ExcelReadConfig;
import top.redscorpion.poi.excel.reader.sheet.MapSheetReader;
import top.redscorpion.poi.excel.reader.sheet.SheetReader;

public class BeanSheetReader<T>
implements SheetReader<List<T>> {
    private final Class<T> beanClass;
    private final MapSheetReader mapSheetReader;

    public BeanSheetReader(int headerRowIndex, int startRowIndex, int endRowIndex, Class<T> beanClass) {
        this.mapSheetReader = new MapSheetReader(headerRowIndex, startRowIndex, endRowIndex);
        this.beanClass = beanClass;
    }

    @Override
    public List<T> read(Sheet sheet) {
        Object mapList = this.mapSheetReader.read(sheet);
        if (Map.class.isAssignableFrom(this.beanClass)) {
            return mapList;
        }
        ArrayList<Object> beanList = new ArrayList<Object>(mapList.size());
        CopyOptions copyOptions = CopyOptions.of().setIgnoreError(true);
        Iterator iterator = mapList.iterator();
        while (iterator.hasNext()) {
            Map map = (Map)iterator.next();
            beanList.add(RsBean.toBean((Object)map, this.beanClass, (CopyOptions)copyOptions));
        }
        return beanList;
    }

    public void setExcelConfig(ExcelReadConfig config) {
        this.mapSheetReader.setExcelConfig(config);
    }
}

