/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.poi.excel.writer;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.poi.common.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;
import top.redscorpion.core.map.multi.Table;
import top.redscorpion.core.util.RsBean;
import top.redscorpion.core.util.RsColl;
import top.redscorpion.core.util.RsList;
import top.redscorpion.core.util.RsMap;
import top.redscorpion.core.util.RsString;
import top.redscorpion.poi.excel.RowGroup;
import top.redscorpion.poi.excel.RsRow;
import top.redscorpion.poi.excel.cell.RsCell;
import top.redscorpion.poi.excel.cell.RsCellRange;
import top.redscorpion.poi.excel.cell.editors.CellEditor;
import top.redscorpion.poi.excel.style.StyleSet;
import top.redscorpion.poi.excel.writer.ExcelWriteConfig;

public class SheetDataWriter {
    private final Sheet sheet;
    private final ExcelWriteConfig config;
    private StyleSet styleSet;
    private Map<String, Integer> headerLocationCache;
    private final AtomicInteger currentRow;

    public SheetDataWriter(Sheet sheet, ExcelWriteConfig config, StyleSet styleSet) {
        this.sheet = sheet;
        this.config = config;
        this.styleSet = styleSet;
        this.currentRow = new AtomicInteger(0);
    }

    public SheetDataWriter setStyleSet(StyleSet styleSet) {
        this.styleSet = styleSet;
        return this;
    }

    public SheetDataWriter setHeaderLocationCache(Map<String, Integer> headerLocationCache) {
        this.headerLocationCache = headerLocationCache;
        return this;
    }

    public SheetDataWriter writeHeader(int x, int y, int rowCount, RowGroup rowGroup) {
        int childrenMaxRowCount;
        String name = rowGroup.getName();
        List<RowGroup> children = rowGroup.getChildren();
        if (null != name) {
            if (RsColl.isNotEmpty(children)) {
                rowCount = Math.max(1, rowCount - rowGroup.childrenMaxRowCount());
            }
            CellRangeAddress cellRangeAddresses = RsCellRange.of(y, y + rowCount - 1, x, x + rowGroup.maxColumnCount() - 1);
            CellStyle style = rowGroup.getStyle();
            if (null == style && null != this.styleSet) {
                style = this.styleSet.getStyleFor(new CellReference(cellRangeAddresses.getFirstRow(), cellRangeAddresses.getFirstColumn()), name, true);
            }
            RsCell.mergingCells(this.sheet, cellRangeAddresses, style);
            Cell cell = RsCell.getOrCreateCell(this.sheet, cellRangeAddresses.getFirstColumn(), cellRangeAddresses.getFirstRow());
            if (null != cell) {
                RsCell.setCellValue(cell, name, style, this.config.getCellEditor());
            }
            y += rowCount;
        }
        if ((childrenMaxRowCount = rowGroup.childrenMaxRowCount()) > 0) {
            for (RowGroup child : children) {
                this.writeHeader(x, y, childrenMaxRowCount, child);
                x += child.maxColumnCount();
            }
        }
        return this;
    }

    public SheetDataWriter writeRow(Object rowBean, boolean isWriteKeyAsHead) {
        Map rowMap;
        ExcelWriteConfig config = this.config;
        if (rowBean instanceof Map) {
            rowMap = RsMap.isNotEmpty(config.getHeaderAlias()) ? RsMap.newTreeMap((Map)((Map)rowBean), config.getCachedAliasComparator()) : (Map)rowBean;
        } else {
            if (rowBean instanceof Iterable) {
                return this.writeRow((Iterable)rowBean);
            }
            if (rowBean instanceof Hyperlink) {
                return this.writeRow(RsList.of((Object[])new Object[]{rowBean}), isWriteKeyAsHead);
            }
            if (RsBean.isReadableBean(rowBean.getClass())) {
                rowMap = RsMap.isEmpty(config.getHeaderAlias()) ? RsBean.beanToMap((Object)rowBean, new LinkedHashMap(), (boolean)false, (boolean)false) : RsBean.beanToMap((Object)rowBean, new TreeMap(config.getCachedAliasComparator()), (boolean)false, (boolean)false);
            } else {
                return this.writeRow(RsList.of((Object[])new Object[]{rowBean}), isWriteKeyAsHead);
            }
        }
        return this.writeRow(rowMap, isWriteKeyAsHead);
    }

    public SheetDataWriter writeRow(Map<?, ?> rowMap, boolean isWriteKeyAsHead) {
        if (RsMap.isEmpty(rowMap)) {
            this.passAndGet();
            return this;
        }
        Table<?, ?, ?> aliasTable = this.config.aliasTable(rowMap);
        if (isWriteKeyAsHead) {
            this.writeHeaderRow(aliasTable.columnKeys());
            int i = 0;
            for (Object key : aliasTable.rowKeySet()) {
                this.headerLocationCache.putIfAbsent(RsString.toString(key), i);
                ++i;
            }
        }
        if (RsMap.isNotEmpty(this.headerLocationCache)) {
            Row row = RsRow.getOrCreateRow(this.sheet, this.currentRow.getAndIncrement());
            CellEditor cellEditor = this.config.getCellEditor();
            for (Table.Cell cell : aliasTable) {
                Integer columnIndex = this.getColumnIndex(cell);
                if (null == columnIndex) continue;
                RsCell.setCellValue(RsCell.getOrCreateCell(row, columnIndex), cell.getValue(), this.styleSet, false, cellEditor);
            }
        } else {
            this.writeRow(aliasTable.values());
        }
        return this;
    }

    public SheetDataWriter writeHeaderRow(Iterable<?> rowData) {
        int rowNum = this.currentRow.getAndIncrement();
        Row row = this.config.insertRow ? this.sheet.createRow(rowNum) : RsRow.getOrCreateRow(this.sheet, rowNum);
        LinkedHashMap<String, Integer> headerLocationCache = new LinkedHashMap<String, Integer>();
        CellEditor cellEditor = this.config.getCellEditor();
        int i = 0;
        for (Object value : rowData) {
            Cell cell = RsCell.getOrCreateCell(row, i);
            RsCell.setCellValue(cell, value, this.styleSet, true, cellEditor);
            headerLocationCache.put(RsString.toString(value), i);
            ++i;
        }
        return this.setHeaderLocationCache(headerLocationCache);
    }

    public SheetDataWriter writeRow(Iterable<?> rowData) {
        int rowNum = this.currentRow.getAndIncrement();
        Row row = this.config.insertRow ? this.sheet.createRow(rowNum) : RsRow.getOrCreateRow(this.sheet, rowNum);
        RsRow.writeRow(row, rowData, this.styleSet, false, this.config.getCellEditor());
        return this;
    }

    public int getCurrentRow() {
        return this.currentRow.get();
    }

    public SheetDataWriter setCurrentRow(int rowIndex) {
        this.currentRow.set(rowIndex);
        return this;
    }

    public int passAndGet() {
        return this.currentRow.incrementAndGet();
    }

    public int passRowsAndGet(int rowNum) {
        return this.currentRow.addAndGet(rowNum);
    }

    public SheetDataWriter resetRow() {
        this.currentRow.set(0);
        return this;
    }

    private Integer getColumnIndex(Table.Cell<?, ?, ?> cell) {
        Integer location = this.headerLocationCache.get(RsString.toString((Object)cell.getRowKey()));
        if (null == location) {
            location = this.headerLocationCache.get(RsString.toString((Object)cell.getColumnKey()));
        }
        return location;
    }
}

