/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.poi.excel;

import java.io.File;
import java.io.InputStream;
import top.redscorpion.core.exception.DependencyException;
import top.redscorpion.core.util.RsFile;
import top.redscorpion.core.util.RsIo;
import top.redscorpion.core.util.RsObject;
import top.redscorpion.poi.excel.RsExcelFile;
import top.redscorpion.poi.excel.reader.ExcelReader;
import top.redscorpion.poi.excel.sax.ExcelSaxReader;
import top.redscorpion.poi.excel.sax.RsExcelSax;
import top.redscorpion.poi.excel.sax.handler.RowHandler;
import top.redscorpion.poi.excel.writer.BigExcelWriter;
import top.redscorpion.poi.excel.writer.ExcelWriter;

public class RsExcel {
    public static final String XLS_CONTENT_TYPE = "application/vnd.ms-excel";
    public static final String XLSX_CONTENT_TYPE = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";

    public static void readBySax(String path, int rid, RowHandler rowHandler) {
        RsExcel.readBySax(RsFile.file((String)path), rid, rowHandler);
    }

    public static void readBySax(String path, String idOrRid, RowHandler rowHandler) {
        RsExcel.readBySax(RsFile.file((String)path), idOrRid, rowHandler);
    }

    public static void readBySax(File file, int rid, RowHandler rowHandler) {
        ExcelSaxReader<?> reader = RsExcelSax.createSaxReader(RsExcelFile.isXlsx(file), rowHandler);
        reader.read(file, rid);
    }

    public static void readBySax(File file, String idOrRidOrSheetName, RowHandler rowHandler) {
        ExcelSaxReader<?> reader = RsExcelSax.createSaxReader(RsExcelFile.isXlsx(file), rowHandler);
        reader.read(file, idOrRidOrSheetName);
    }

    public static void readBySax(InputStream in, int rid, RowHandler rowHandler) {
        in = RsIo.toMarkSupport((InputStream)in);
        ExcelSaxReader<?> reader = RsExcelSax.createSaxReader(RsExcelFile.isXlsx(in), rowHandler);
        reader.read(in, rid);
    }

    public static void readBySax(InputStream in, String idOrRidOrSheetName, RowHandler rowHandler) {
        in = RsIo.toMarkSupport((InputStream)in);
        ExcelSaxReader<?> reader = RsExcelSax.createSaxReader(RsExcelFile.isXlsx(in), rowHandler);
        reader.read(in, idOrRidOrSheetName);
    }

    public static ExcelReader getReader(String bookFilePath) {
        return RsExcel.getReader(bookFilePath, 0);
    }

    public static ExcelReader getReader(File bookFile) {
        return RsExcel.getReader(bookFile, 0);
    }

    public static ExcelReader getReader(String bookFilePath, int sheetIndex) {
        try {
            return new ExcelReader(bookFilePath, sheetIndex);
        }
        catch (NoClassDefFoundError e) {
            throw new DependencyException((Throwable)RsObject.defaultIfNull((Object)e.getCause(), (Object)e), "You need to add dependency of 'poi-ooxml' to your project, and version >= 5.3.0", new Object[0]);
        }
    }

    public static ExcelReader getReader(String bookFilePath, String sheetName) {
        try {
            return new ExcelReader(bookFilePath, sheetName);
        }
        catch (NoClassDefFoundError e) {
            throw new DependencyException((Throwable)RsObject.defaultIfNull((Object)e.getCause(), (Object)e), "You need to add dependency of 'poi-ooxml' to your project, and version >= 5.3.0", new Object[0]);
        }
    }

    public static ExcelReader getReader(File bookFile, int sheetIndex) {
        try {
            return new ExcelReader(bookFile, sheetIndex);
        }
        catch (NoClassDefFoundError e) {
            throw new DependencyException((Throwable)RsObject.defaultIfNull((Object)e.getCause(), (Object)e), "You need to add dependency of 'poi-ooxml' to your project, and version >= 5.3.0", new Object[0]);
        }
    }

    public static ExcelReader getReader(File bookFile, String sheetName) {
        try {
            return new ExcelReader(bookFile, sheetName);
        }
        catch (NoClassDefFoundError e) {
            throw new DependencyException((Throwable)RsObject.defaultIfNull((Object)e.getCause(), (Object)e), "You need to add dependency of 'poi-ooxml' to your project, and version >= 5.3.0", new Object[0]);
        }
    }

    public static ExcelReader getReader(InputStream bookStream) {
        return RsExcel.getReader(bookStream, 0);
    }

    public static ExcelReader getReader(InputStream bookStream, int sheetIndex) {
        try {
            return new ExcelReader(bookStream, sheetIndex);
        }
        catch (NoClassDefFoundError e) {
            throw new DependencyException((Throwable)RsObject.defaultIfNull((Object)e.getCause(), (Object)e), "You need to add dependency of 'poi-ooxml' to your project, and version >= 5.3.0", new Object[0]);
        }
    }

    public static ExcelReader getReader(InputStream bookStream, String sheetName) {
        try {
            return new ExcelReader(bookStream, sheetName);
        }
        catch (NoClassDefFoundError e) {
            throw new DependencyException((Throwable)RsObject.defaultIfNull((Object)e.getCause(), (Object)e), "You need to add dependency of 'poi-ooxml' to your project, and version >= 5.3.0", new Object[0]);
        }
    }

    public static ExcelWriter getWriter() {
        try {
            return new ExcelWriter();
        }
        catch (NoClassDefFoundError e) {
            throw new DependencyException((Throwable)RsObject.defaultIfNull((Object)e.getCause(), (Object)e), "You need to add dependency of 'poi-ooxml' to your project, and version >= 5.3.0", new Object[0]);
        }
    }

    public static ExcelWriter getWriter(boolean isXlsx) {
        try {
            return new ExcelWriter(isXlsx);
        }
        catch (NoClassDefFoundError e) {
            throw new DependencyException((Throwable)RsObject.defaultIfNull((Object)e.getCause(), (Object)e), "You need to add dependency of 'poi-ooxml' to your project, and version >= 5.3.0", new Object[0]);
        }
    }

    public static ExcelWriter getWriter(String templateFilePath) {
        try {
            return new ExcelWriter(templateFilePath);
        }
        catch (NoClassDefFoundError e) {
            throw new DependencyException((Throwable)RsObject.defaultIfNull((Object)e.getCause(), (Object)e), "You need to add dependency of 'poi-ooxml' to your project, and version >= 5.3.0", new Object[0]);
        }
    }

    public static ExcelWriter getWriterWithSheet(String sheetName) {
        try {
            return new ExcelWriter((File)null, sheetName);
        }
        catch (NoClassDefFoundError e) {
            throw new DependencyException((Throwable)RsObject.defaultIfNull((Object)e.getCause(), (Object)e), "You need to add dependency of 'poi-ooxml' to your project, and version >= 5.3.0", new Object[0]);
        }
    }

    public static ExcelWriter getWriter(File templateFile) {
        try {
            return new ExcelWriter(templateFile);
        }
        catch (NoClassDefFoundError e) {
            throw new DependencyException((Throwable)RsObject.defaultIfNull((Object)e.getCause(), (Object)e), "You need to add dependency of 'poi-ooxml' to your project, and version >= 5.3.0", new Object[0]);
        }
    }

    public static ExcelWriter getWriter(String templateFilePath, String sheetName) {
        try {
            return new ExcelWriter(templateFilePath, sheetName);
        }
        catch (NoClassDefFoundError e) {
            throw new DependencyException((Throwable)RsObject.defaultIfNull((Object)e.getCause(), (Object)e), "You need to add dependency of 'poi-ooxml' to your project, and version >= 5.3.0", new Object[0]);
        }
    }

    public static ExcelWriter getWriter(File templateFilePath, String sheetName) {
        try {
            return new ExcelWriter(templateFilePath, sheetName);
        }
        catch (NoClassDefFoundError e) {
            throw new DependencyException((Throwable)RsObject.defaultIfNull((Object)e.getCause(), (Object)e), "You need to add dependency of 'poi-ooxml' to your project, and version >= 5.3.0", new Object[0]);
        }
    }

    public static BigExcelWriter getBigWriter() {
        try {
            return new BigExcelWriter();
        }
        catch (NoClassDefFoundError e) {
            throw new DependencyException((Throwable)RsObject.defaultIfNull((Object)e.getCause(), (Object)e), "You need to add dependency of 'poi-ooxml' to your project, and version >= 5.3.0", new Object[0]);
        }
    }

    public static BigExcelWriter getBigWriter(int rowAccessWindowSize) {
        try {
            return new BigExcelWriter(rowAccessWindowSize);
        }
        catch (NoClassDefFoundError e) {
            throw new DependencyException((Throwable)RsObject.defaultIfNull((Object)e.getCause(), (Object)e), "You need to add dependency of 'poi-ooxml' to your project, and version >= 5.3.0", new Object[0]);
        }
    }

    public static BigExcelWriter getBigWriter(String destFilePath) {
        try {
            return new BigExcelWriter(destFilePath);
        }
        catch (NoClassDefFoundError e) {
            throw new DependencyException((Throwable)RsObject.defaultIfNull((Object)e.getCause(), (Object)e), "You need to add dependency of 'poi-ooxml' to your project, and version >= 5.3.0", new Object[0]);
        }
    }

    public static BigExcelWriter getBigWriter(File destFile) {
        try {
            return new BigExcelWriter(destFile);
        }
        catch (NoClassDefFoundError e) {
            throw new DependencyException((Throwable)RsObject.defaultIfNull((Object)e.getCause(), (Object)e), "You need to add dependency of 'poi-ooxml' to your project, and version >= 5.3.0", new Object[0]);
        }
    }

    public static BigExcelWriter getBigWriter(String destFilePath, String sheetName) {
        try {
            return new BigExcelWriter(destFilePath, sheetName);
        }
        catch (NoClassDefFoundError e) {
            throw new DependencyException((Throwable)RsObject.defaultIfNull((Object)e.getCause(), (Object)e), "You need to add dependency of 'poi-ooxml' to your project, and version >= 5.3.0", new Object[0]);
        }
    }

    public static BigExcelWriter getBigWriter(File destFile, String sheetName) {
        try {
            return new BigExcelWriter(destFile, sheetName);
        }
        catch (NoClassDefFoundError e) {
            throw new DependencyException((Throwable)RsObject.defaultIfNull((Object)e.getCause(), (Object)e), "You need to add dependency of 'poi-ooxml' to your project, and version >= 5.3.0", new Object[0]);
        }
    }
}

