package top.rish.converter.info;

import lombok.Data;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Data
public class EntityWrap {

    public Type type;
    public String name;
    public List<AnnoWrap> annoList;

    public static final Map<Class<?>,EntityWrap> CACHE = new HashMap<>();

    public static EntityWrap of(Object o) {
        Class<?> c = o.getClass();
        if(CACHE.containsKey(c)){
            return CACHE.get(c);
        }
        EntityWrap ew = new EntityWrap();
        ew.setType(o.getClass());
        ew.setName(o.getClass().getName());
        ew.setAnnoList(AnnoWrap.ofEntity(o));
        CACHE.put(c,ew);
        return ew;
    }
}
