package top.rish.converter.info;

import lombok.Data;
import top.rish.converter.base.DictEntity;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Data
public class FieldWrap {
    EntityWrap entityWrap;
    // 字段注解信息
    public List<AnnoWrap> annoList;
    public Type   type;
    public String typeName;
    public String name;
    public Field field;

    public static final Map<Field,FieldWrap> CACHE = new HashMap<>();

    public static FieldWrap of( Field field){
        if(CACHE.containsKey(field)){
            return CACHE.get(field);
        }
        FieldWrap f = new FieldWrap();
        f.setField(field);
        f.setType(field.getType());
        f.setName(field.getName());
        f.setTypeName(field.getType().getName());
        f.setAnnoList(AnnoWrap.ofField(field));
        CACHE.put(field,f);
        return f;
    }

}
