/*
 * Decompiled with CFR 0.152.
 */
package top.rish.converter.utils;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import top.rish.converter.utils.ObjKit;

public class RefKit {
    private static final Map<Class<?>, Set<Field>> CACHE_FIELDS = new ConcurrentHashMap();

    public static <T> T getGenericClass(Class<?> c, int i) {
        Type[] superclass;
        for (Type type : superclass = c.getGenericInterfaces()) {
            ParameterizedType parameterizedType;
            Type[] arguments;
            if (!(type instanceof ParameterizedType) || i >= (arguments = (parameterizedType = (ParameterizedType)type).getActualTypeArguments()).length) continue;
            return (T)arguments[i];
        }
        return null;
    }

    public static Enum<?> getEnumByValue(Class<? extends Enum<?>> enumClass, Object value) {
        if (value instanceof CharSequence) {
            value = value.toString().trim();
        }
        Set<Field> fields = RefKit.getAllFields(enumClass);
        Enum<?>[] enums = enumClass.getEnumConstants();
        for (Field field : fields) {
            String fieldName = field.getName();
            if (field.getType().isEnum() || "ENUM$VALUES".equals(fieldName) || "ordinal".equals(fieldName)) continue;
            for (Enum<?> enumObj : enums) {
                if (!ObjKit.equal(value, RefKit.getFieldValue(enumObj, field))) continue;
                return enumObj;
            }
        }
        return null;
    }

    public static Set<Field> getAllFields(Object o) {
        Field[] fields;
        if (ObjKit.isEmpty(o) || ObjKit.isTypeCollect(o) || ObjKit.isMap(o) || ObjKit.isAnnotation(o) || ObjKit.isEnum(o) || ObjKit.isNumber(o)) {
            return ObjKit.newEpmtySet(Field.class);
        }
        Class<?> oc = o instanceof Class ? (Class<?>)o : o.getClass();
        if (ObjKit.isNotEmpty(CACHE_FIELDS.get(oc))) {
            return CACHE_FIELDS.get(oc);
        }
        for (Field f : fields = oc.getDeclaredFields()) {
            f.setAccessible(true);
        }
        Set<Field> list = ObjKit.toSet(fields);
        CACHE_FIELDS.put(oc, list);
        return CACHE_FIELDS.get(oc);
    }

    public static Object getFieldValue(Object o, Field f) {
        if (!ObjKit.isAllNotEmpty(o, f)) {
            return null;
        }
        try {
            f.setAccessible(true);
            return f.get(o);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

