/*
 * Decompiled with CFR 0.152.
 */
package top.rish.converter.springboot;

import java.util.Map;
import java.util.Objects;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;
import top.rish.converter.factory.ConvertMetropolitan;
import top.rish.converter.handler.ConvertHandler;

@ControllerAdvice
public class DictConverterResponseBodyInterceptor
implements ApplicationContextAware,
ResponseBodyAdvice<Object> {
    private ApplicationContext context;

    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType) {
        return true;
    }

    public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        Map beansOfType = this.context.getBeansOfType(ConvertHandler.class);
        beansOfType.values().forEach(ConvertMetropolitan::registerHandler);
        ConvertMetropolitan.registerFields((Object)body);
        Object converted = ConvertMetropolitan.convert((Object)body);
        if (!Objects.equals(body, converted)) {
            body = converted;
        }
        return body;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }
}

