/*
 * Decompiled with CFR 0.152.
 */
package top.rish.converter.core.factory;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import top.rish.converter.core.annotation.handler.DictConvertHandler;
import top.rish.converter.core.base.DictEntity;
import top.rish.converter.core.info.EntityWrap;
import top.rish.converter.core.info.FieldWrap;
import top.rish.converter.core.info.MetaMap;
import top.rish.converter.core.utils.ObjKit;
import top.rish.converter.core.utils.RefKit;

public class SolonDictConvertFactory {
    public static final Map<Field, List<DictConvertHandler<? extends Annotation>>> FIELD_AND_HANDLER = new ConcurrentHashMap<Field, List<DictConvertHandler<? extends Annotation>>>();
    public static final Map<Field, FieldWrap> FIELD_FIELD_WRAP_MAP = new ConcurrentHashMap<Field, FieldWrap>();
    public static final Map<Class<?>, Set<Field>> ENTITY_CLASS_AND_FIELDS = new ConcurrentHashMap();
    public static final Map<Class<? extends Annotation>, DictConvertHandler<? extends Annotation>> ANNO_AND_HANDLER = new ConcurrentHashMap<Class<? extends Annotation>, DictConvertHandler<? extends Annotation>>();
    public static final List<DictConvertHandler<? extends Annotation>> HANDLERS = new ArrayList<DictConvertHandler<? extends Annotation>>();

    public static void registerHandler(DictConvertHandler<? extends Annotation> handler) {
        if (ObjKit.isEmpty(handler)) {
            return;
        }
        Class<? extends Annotation> ac = handler.getAnnonationClass();
        if (ac == null) {
            return;
        }
        HANDLERS.add(handler);
        if (!ANNO_AND_HANDLER.containsKey(ac)) {
            ANNO_AND_HANDLER.put(ac, handler);
        }
    }

    public static Set<Field> getAllDictFields(Object o) {
        if (o instanceof DictEntity) {
            return RefKit.getAllFields(o);
        }
        return null;
    }

    public static void putEntityAndFields(Class<?> oc, Set<Field> fields) {
        if (!ENTITY_CLASS_AND_FIELDS.containsKey(oc)) {
            ENTITY_CLASS_AND_FIELDS.put(oc, fields);
        } else {
            Set<Field> fieldList = ENTITY_CLASS_AND_FIELDS.get(oc);
            fieldList.addAll(fields);
        }
    }

    public static void registerDictEntityFields(Object o) {
        if (ObjKit.isEmpty(o)) {
            return;
        }
        if (ObjKit.isTypeCollect(o)) {
            if (ObjKit.isArray(o)) {
                Object[] ol;
                for (Object oo : ol = (Object[])o) {
                    SolonDictConvertFactory.registerDictEntityFields(oo);
                }
            } else if (ObjKit.isIterable(o)) {
                Iterable iterable = (Iterable)o;
                iterable.forEach(SolonDictConvertFactory::registerDictEntityFields);
            } else if (ObjKit.isIterator(o)) {
                Iterator iterator = (Iterator)o;
                while (iterator.hasNext()) {
                    SolonDictConvertFactory.registerDictEntityFields(iterator.next());
                }
            }
        } else if (ObjKit.isMap(o)) {
            Map map = (Map)o;
            map.keySet().forEach(SolonDictConvertFactory::registerDictEntityFields);
            map.values().forEach(SolonDictConvertFactory::registerDictEntityFields);
        } else {
            Class<?> oc = o.getClass();
            Set<Field> dictFields = SolonDictConvertFactory.getAllDictFields(o);
            if (ObjKit.isEmpty(dictFields)) {
                return;
            }
            if (ObjKit.isEmpty(HANDLERS)) {
                return;
            }
            EntityWrap entityWrap = EntityWrap.of(o);
            for (Field f : dictFields) {
                FieldWrap fw = FieldWrap.of(f);
                Annotation[] annotations = f.getAnnotations();
                if (ObjKit.isEmpty(annotations)) continue;
                FIELD_FIELD_WRAP_MAP.put(f, fw);
                fw.setEntityWrap(entityWrap);
                List handlerList = Arrays.stream(annotations).map(a -> ANNO_AND_HANDLER.get(a.annotationType())).collect(Collectors.toList());
                if (!ObjKit.isNotEmpty(handlerList)) continue;
                FIELD_AND_HANDLER.put(f, handlerList);
            }
            SolonDictConvertFactory.putEntityAndFields(oc, dictFields);
        }
    }

    public static Object convert(Object o) {
        if (ObjKit.isEmpty(HANDLERS)) {
            return o;
        }
        if (ObjKit.isTypeCollect(o)) {
            ArrayList<Object> objList;
            if (ObjKit.isArray(o)) {
                Object[] ol = (Object[])o;
                objList = new ArrayList<Object>(Arrays.asList(ol));
            } else if (ObjKit.isIterable(o)) {
                objList = new ArrayList();
                Iterable iterable = (Iterable)o;
                iterable.forEach(objList::add);
            } else if (ObjKit.isIterator(o)) {
                objList = new ArrayList();
                Iterator iterator = (Iterator)o;
                while (iterator.hasNext()) {
                    objList.add(iterator.next());
                }
            } else {
                return o;
            }
            return objList.stream().map(SolonDictConvertFactory::convert).collect(Collectors.toList());
        }
        if (ObjKit.isMap(o)) {
            Map map = (Map)o;
            HashMap om = new HashMap();
            map.forEach((k, v) -> om.put(SolonDictConvertFactory.convert(k), SolonDictConvertFactory.convert(v)));
            return om;
        }
        if (o instanceof DictEntity) {
            Set<Field> fs = RefKit.getAllFields(o);
            MetaMap mateMap = MetaMap.ofEntity(o);
            if (ObjKit.isNotEmpty(fs)) {
                for (Field field : fs) {
                    Object value = RefKit.getFieldValue(o, field);
                    mateMap.put(field.getName(), SolonDictConvertFactory.convert(value));
                    List<DictConvertHandler<? extends Annotation>> handlers = FIELD_AND_HANDLER.get(field);
                    FieldWrap fieldWrap = FIELD_FIELD_WRAP_MAP.get(field);
                    if (!ObjKit.isNotEmpty(handlers)) continue;
                    for (DictConvertHandler<? extends Annotation> handler : handlers) {
                        Class aClass = (Class)RefKit.getGenericClass(handler.getClass(), 0);
                        assert (aClass != null);
                        Object annotation = field.getAnnotation(aClass);
                        handler.doConvert(mateMap, (DictEntity)o, value, fieldWrap, (Annotation)annotation);
                    }
                }
            }
            return mateMap;
        }
        return o;
    }
}

