/*
 * Decompiled with CFR 0.152.
 */
package top.rizon.rtools.restemplate;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpRequest;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

public class PrintCurlClientHttpRequestInterceptor
implements ClientHttpRequestInterceptor {
    private static final Logger log = LoggerFactory.getLogger(PrintCurlClientHttpRequestInterceptor.class);
    private String separator = " ";
    private boolean debugLog = false;
    private List<String> ignoreHeaders = new ArrayList<String>(Arrays.asList("Accept", "Content-Length"));

    public static PrintCurlInterceptorBuilder builder() {
        return new PrintCurlInterceptorBuilder();
    }

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        try {
            this.printCurl(request, body);
        }
        catch (Exception ex) {
            log.warn("print curl error", (Throwable)ex);
        }
        return execution.execute(request, body);
    }

    public void printCurl(HttpRequest request, byte[] body) {
        ArrayList<CObj> cObjects = new ArrayList<CObj>();
        cObjects.add(new CMethod(request.getMethodValue()));
        cObjects.add(new CUrl(request.getURI()));
        request.getHeaders().forEach((key, vals) -> {
            if (this.ignoreHeaders.contains(key)) {
                return;
            }
            cObjects.add(new CHead((String)key, (List<String>)vals));
        });
        cObjects.add(new CBody(this.separator, request.getHeaders().getContentType(), body));
        cObjects.removeIf(Objects::isNull);
        String logMsg = StringUtils.join(cObjects, (String)this.separator);
        if (this.debugLog) {
            log.debug("Request-Curl:\n{}", (Object)logMsg);
        } else {
            log.info("Request-Curl:\n{}", (Object)logMsg);
        }
    }

    public static class CBody
    implements CObj {
        private final String separator;
        private final MediaType mediaType;
        private final byte[] body;

        public String toString() {
            if (this.body.length == 0) {
                return null;
            }
            if (MediaType.MULTIPART_FORM_DATA.isCompatibleWith(this.mediaType)) {
                return this.parseForm(this.separator, "-F", this.body);
            }
            if (MediaType.APPLICATION_FORM_URLENCODED.isCompatibleWith(this.mediaType)) {
                return this.parseUrlEncode(this.separator, "--data-urlencode", this.body);
            }
            return "-d '" + new String(this.body) + "'";
        }

        private String parseUrlEncode(String separator, String param, byte[] body) {
            String[] kvList;
            ArrayList<String> results = new ArrayList<String>();
            for (String kv : kvList = StringUtils.split((String)new String(body), (String)"&")) {
                String[] kvSplit = kv.split("=", 2);
                results.add(String.format("%s '%s=\"%s\"'", param, kvSplit[0], kvSplit.length > 1 ? kvSplit[1] : ""));
            }
            return StringUtils.join(results, (String)separator);
        }

        private String parseForm(String separator, String param, byte[] body) {
            String line;
            ArrayList<String> results = new ArrayList<String>();
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(body), StandardCharsets.UTF_8));
            while ((line = br.readLine()) != null) {
                String line2;
                if (!line.startsWith("Content-Disposition")) continue;
                String key = line.split("name=", 2)[1];
                key = key.substring(1, key.length() - 1);
                String value = null;
                while ((line2 = br.readLine()) != null) {
                    if (line2.length() > 0) continue;
                    value = br.readLine();
                    break;
                }
                results.add(String.format("%s '%s=\"%s\"'", param, key, value));
            }
            return StringUtils.join(results, (String)separator);
        }

        public CBody(String separator, MediaType mediaType, byte[] body) {
            this.separator = separator;
            this.mediaType = mediaType;
            this.body = body;
        }
    }

    public static class CHead
    implements CObj {
        private final String key;
        private final List<String> values;

        public String toString() {
            return String.format("-H '%s: %s'", this.key, StringUtils.join(this.values, (String)";"));
        }

        public CHead(String key, List<String> values) {
            this.key = key;
            this.values = values;
        }
    }

    public static class CUrl
    implements CObj {
        private final URI uri;

        public String toString() {
            return "'" + this.uri.toString() + "'";
        }

        public CUrl(URI uri) {
            this.uri = uri;
        }
    }

    public static class CMethod
    implements CObj {
        private final String method;

        public String toString() {
            return "curl -X " + this.method;
        }

        public CMethod(String method) {
            this.method = method;
        }
    }

    public static interface CObj {
    }

    public static class PrintCurlInterceptorBuilder {
        private final PrintCurlClientHttpRequestInterceptor interceptor = new PrintCurlClientHttpRequestInterceptor();

        public PrintCurlInterceptorBuilder setMultiLine() {
            this.interceptor.separator = " \\\n";
            return this;
        }

        public PrintCurlInterceptorBuilder setSingleLine() {
            this.interceptor.separator = " ";
            return this;
        }

        public PrintCurlInterceptorBuilder setDebugLog() {
            this.interceptor.debugLog = true;
            return this;
        }

        public PrintCurlInterceptorBuilder setInfoLog() {
            this.interceptor.debugLog = false;
            return this;
        }

        public PrintCurlInterceptorBuilder appendIgnoreHeaders(@NonNull List<String> headerKeys) {
            if (headerKeys == null) {
                throw new NullPointerException("headerKeys is marked @NonNull but is null");
            }
            this.interceptor.ignoreHeaders.addAll(headerKeys);
            return this;
        }

        public PrintCurlInterceptorBuilder setIgnoreHeaders(@NonNull List<String> headerKeys) {
            if (headerKeys == null) {
                throw new NullPointerException("headerKeys is marked @NonNull but is null");
            }
            this.interceptor.ignoreHeaders = headerKeys;
            return this;
        }

        public PrintCurlClientHttpRequestInterceptor build() {
            return this.interceptor;
        }
    }
}

