/*
 * Decompiled with CFR 0.152.
 */
package top.rizon.rtools.restemplate;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpRequest;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.CollectionUtils;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@Configuration
@ConditionalOnProperty(value={"r-tools.rest-template.print-curl.enable"}, havingValue="true", matchIfMissing=true)
@ConfigurationProperties(prefix="r-tools.rest-template.print-curl")
@Order
public class PrintCurlClientHttpRequestInterceptor
implements ClientHttpRequestInterceptor,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(PrintCurlClientHttpRequestInterceptor.class);
    private static final AntPathMatcher PATH_MATCHER = new AntPathMatcher();
    private final RestTemplate restTemplate;
    private boolean enable = true;
    private String separator = " ";
    private boolean debugLog = false;
    private List<String> ignoreHeaders = new ArrayList<String>(Arrays.asList("Accept", "Content-Length"));
    private List<String> urlWishlist = new ArrayList<String>();

    public void afterPropertiesSet() {
        if (this.restTemplate != null) {
            this.restTemplate.getInterceptors().add(this);
            log.info("restTemplate register interceptor: " + this.getClass().getName());
        }
    }

    public static PrintCurlInterceptorBuilder builder() {
        return new PrintCurlInterceptorBuilder();
    }

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        try {
            if (this.enable && this.needPrint(request)) {
                String curl = this.toCurl(request, body);
                if (this.debugLog) {
                    log.debug("Request-Curl:\n{}", (Object)curl);
                } else {
                    log.info("Request-Curl:\n{}", (Object)curl);
                }
            }
        }
        catch (Exception ex) {
            log.warn("print curl error", (Throwable)ex);
        }
        return execution.execute(request, body);
    }

    private boolean needPrint(HttpRequest request) {
        if (CollectionUtils.isEmpty(this.urlWishlist)) {
            return true;
        }
        String requestUrl = UriComponentsBuilder.fromUri((URI)request.getURI()).replaceQueryParams(null).toUriString();
        return this.urlWishlist.stream().anyMatch(url -> PATH_MATCHER.match(url, requestUrl));
    }

    public String toCurl(HttpRequest request, byte[] body) {
        ArrayList<CObj> cObjects = new ArrayList<CObj>();
        cObjects.add(new CMethod(request.getMethodValue()));
        cObjects.add(new CUrl(request.getURI()));
        request.getHeaders().forEach((key, vals) -> {
            if (this.ignoreHeaders.contains(key)) {
                return;
            }
            cObjects.add(new CHead((String)key, (List<String>)vals));
        });
        cObjects.add(new CBody(this.separator, request.getHeaders().getContentType(), body));
        return cObjects.stream().map(Object::toString).filter(Objects::nonNull).collect(Collectors.joining(this.separator));
    }

    public PrintCurlClientHttpRequestInterceptor(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public String getSeparator() {
        return this.separator;
    }

    public boolean isDebugLog() {
        return this.debugLog;
    }

    public List<String> getIgnoreHeaders() {
        return this.ignoreHeaders;
    }

    public List<String> getUrlWishlist() {
        return this.urlWishlist;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public void setDebugLog(boolean debugLog) {
        this.debugLog = debugLog;
    }

    public void setIgnoreHeaders(List<String> ignoreHeaders) {
        this.ignoreHeaders = ignoreHeaders;
    }

    public void setUrlWishlist(List<String> urlWishlist) {
        this.urlWishlist = urlWishlist;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PrintCurlClientHttpRequestInterceptor)) {
            return false;
        }
        PrintCurlClientHttpRequestInterceptor other = (PrintCurlClientHttpRequestInterceptor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RestTemplate this$restTemplate = this.getRestTemplate();
        RestTemplate other$restTemplate = other.getRestTemplate();
        if (this$restTemplate == null ? other$restTemplate != null : !this$restTemplate.equals(other$restTemplate)) {
            return false;
        }
        if (this.isEnable() != other.isEnable()) {
            return false;
        }
        String this$separator = this.getSeparator();
        String other$separator = other.getSeparator();
        if (this$separator == null ? other$separator != null : !this$separator.equals(other$separator)) {
            return false;
        }
        if (this.isDebugLog() != other.isDebugLog()) {
            return false;
        }
        List<String> this$ignoreHeaders = this.getIgnoreHeaders();
        List<String> other$ignoreHeaders = other.getIgnoreHeaders();
        if (this$ignoreHeaders == null ? other$ignoreHeaders != null : !((Object)this$ignoreHeaders).equals(other$ignoreHeaders)) {
            return false;
        }
        List<String> this$urlWishlist = this.getUrlWishlist();
        List<String> other$urlWishlist = other.getUrlWishlist();
        return !(this$urlWishlist == null ? other$urlWishlist != null : !((Object)this$urlWishlist).equals(other$urlWishlist));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PrintCurlClientHttpRequestInterceptor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RestTemplate $restTemplate = this.getRestTemplate();
        result = result * 59 + ($restTemplate == null ? 43 : $restTemplate.hashCode());
        result = result * 59 + (this.isEnable() ? 79 : 97);
        String $separator = this.getSeparator();
        result = result * 59 + ($separator == null ? 43 : $separator.hashCode());
        result = result * 59 + (this.isDebugLog() ? 79 : 97);
        List<String> $ignoreHeaders = this.getIgnoreHeaders();
        result = result * 59 + ($ignoreHeaders == null ? 43 : ((Object)$ignoreHeaders).hashCode());
        List<String> $urlWishlist = this.getUrlWishlist();
        result = result * 59 + ($urlWishlist == null ? 43 : ((Object)$urlWishlist).hashCode());
        return result;
    }

    public String toString() {
        return "PrintCurlClientHttpRequestInterceptor(restTemplate=" + this.getRestTemplate() + ", enable=" + this.isEnable() + ", separator=" + this.getSeparator() + ", debugLog=" + this.isDebugLog() + ", ignoreHeaders=" + this.getIgnoreHeaders() + ", urlWishlist=" + this.getUrlWishlist() + ")";
    }

    public static class CBody
    implements CObj {
        private final String separator;
        private final MediaType mediaType;
        private final byte[] body;

        public String toString() {
            if (this.body.length == 0) {
                return null;
            }
            if (MediaType.MULTIPART_FORM_DATA.isCompatibleWith(this.mediaType)) {
                return this.parseForm(this.separator, "-F", this.body);
            }
            if (MediaType.APPLICATION_FORM_URLENCODED.isCompatibleWith(this.mediaType)) {
                return this.parseUrlEncode(this.separator, "--data-urlencode", this.body);
            }
            return "-d '" + new String(this.body) + "'";
        }

        private String parseUrlEncode(String separator, String param, byte[] body) {
            String[] kvList;
            ArrayList<String> results = new ArrayList<String>();
            for (String kv : kvList = StringUtils.split((String)new String(body), (String)"&")) {
                String[] kvSplit = kv.split("=", 2);
                results.add(String.format("%s '%s=\"%s\"'", param, kvSplit[0], kvSplit.length > 1 ? kvSplit[1] : ""));
            }
            return StringUtils.join(results, (String)separator);
        }

        private String parseForm(String separator, String param, byte[] body) {
            String line;
            ArrayList<String> results = new ArrayList<String>();
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(body), StandardCharsets.UTF_8));
            while ((line = br.readLine()) != null) {
                String line2;
                if (!line.startsWith("Content-Disposition")) continue;
                String key = line.split("name=", 2)[1];
                key = key.substring(1, key.length() - 1);
                String value = null;
                while ((line2 = br.readLine()) != null) {
                    if (line2.length() > 0) continue;
                    value = br.readLine();
                    break;
                }
                results.add(String.format("%s '%s=\"%s\"'", param, key, value));
            }
            return StringUtils.join(results, (String)separator);
        }

        public CBody(String separator, MediaType mediaType, byte[] body) {
            this.separator = separator;
            this.mediaType = mediaType;
            this.body = body;
        }
    }

    public static class CHead
    implements CObj {
        private final String key;
        private final List<String> values;

        public String toString() {
            return String.format("-H '%s: %s'", this.key, StringUtils.join(this.values, (String)";"));
        }

        public CHead(String key, List<String> values) {
            this.key = key;
            this.values = values;
        }
    }

    public static class CUrl
    implements CObj {
        private final URI uri;

        public String toString() {
            return "'" + this.uri.toString() + "'";
        }

        public CUrl(URI uri) {
            this.uri = uri;
        }
    }

    public static class CMethod
    implements CObj {
        private final String method;

        public String toString() {
            return "curl -X " + this.method;
        }

        public CMethod(String method) {
            this.method = method;
        }
    }

    public static interface CObj {
    }

    public static class PrintCurlInterceptorBuilder {
        private final PrintCurlClientHttpRequestInterceptor interceptor = new PrintCurlClientHttpRequestInterceptor(null);

        public PrintCurlInterceptorBuilder setMultiLine() {
            this.interceptor.separator = " \\\n";
            return this;
        }

        public PrintCurlInterceptorBuilder setSingleLine() {
            this.interceptor.separator = " ";
            return this;
        }

        public PrintCurlInterceptorBuilder setDebugLog() {
            this.interceptor.debugLog = true;
            return this;
        }

        public PrintCurlInterceptorBuilder setInfoLog() {
            this.interceptor.debugLog = false;
            return this;
        }

        public PrintCurlInterceptorBuilder appendIgnoreHeaders(@NonNull List<String> headerKeys) {
            if (headerKeys == null) {
                throw new NullPointerException("headerKeys is marked @NonNull but is null");
            }
            this.interceptor.ignoreHeaders.addAll(headerKeys);
            return this;
        }

        public PrintCurlInterceptorBuilder setIgnoreHeaders(@NonNull List<String> headerKeys) {
            if (headerKeys == null) {
                throw new NullPointerException("headerKeys is marked @NonNull but is null");
            }
            this.interceptor.ignoreHeaders = headerKeys;
            return this;
        }

        public PrintCurlInterceptorBuilder setPrintUrlWishlist(@NonNull List<String> urlPatterns) {
            if (urlPatterns == null) {
                throw new NullPointerException("urlPatterns is marked @NonNull but is null");
            }
            this.interceptor.urlWishlist = urlPatterns;
            return this;
        }

        public PrintCurlClientHttpRequestInterceptor build() {
            return this.interceptor;
        }
    }
}

