/*
 * Decompiled with CFR 0.152.
 */
package top.rizon.rtools.restemplate;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.client.RestTemplate;

@Configuration
@ConditionalOnProperty(value={"r-tools.rest-template.mock.enable"}, havingValue="true")
@ConfigurationProperties(prefix="r-tools.rest-template.mock")
@Order
public class MockRestTemplateInterceptor
implements ClientHttpRequestInterceptor,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(MockRestTemplateInterceptor.class);
    private static final AntPathMatcher PATH_MATCHER = new AntPathMatcher();
    private final RestTemplate restTemplate;
    private boolean enable = false;
    private List<MockConf> conf = new ArrayList<MockConf>();

    public void afterPropertiesSet() {
        if (this.restTemplate != null) {
            this.restTemplate.getInterceptors().add(this);
            log.info("restTemplate register interceptor: " + this.getClass().getName());
        }
    }

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        if (this.enable) {
            String url = request.getURI().toString();
            for (MockConf mockConf : this.conf) {
                if (!PATH_MATCHER.match(mockConf.getUrl(), url)) continue;
                return this.mockResponse(request.getHeaders(), mockConf.getBody());
            }
        }
        return execution.execute(request, body);
    }

    private ClientHttpResponse mockResponse(final HttpHeaders headers, final String body) {
        final ByteArrayInputStream inputStream = new ByteArrayInputStream(body.getBytes());
        return new ClientHttpResponse(){

            public HttpHeaders getHeaders() {
                HttpHeaders resHeaders = new HttpHeaders();
                resHeaders.setContentType((MediaType)headers.getAccept().get(0));
                resHeaders.setContentLength((long)body.length());
                return resHeaders;
            }

            public InputStream getBody() throws IOException {
                return inputStream;
            }

            public HttpStatus getStatusCode() throws IOException {
                return HttpStatus.OK;
            }

            public int getRawStatusCode() throws IOException {
                return this.getStatusCode().value();
            }

            public String getStatusText() throws IOException {
                return this.getStatusCode().name();
            }

            public void close() {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.error("close inputStream error", (Throwable)e);
                }
            }
        };
    }

    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public List<MockConf> getConf() {
        return this.conf;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public void setConf(List<MockConf> conf) {
        this.conf = conf;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MockRestTemplateInterceptor)) {
            return false;
        }
        MockRestTemplateInterceptor other = (MockRestTemplateInterceptor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RestTemplate this$restTemplate = this.getRestTemplate();
        RestTemplate other$restTemplate = other.getRestTemplate();
        if (this$restTemplate == null ? other$restTemplate != null : !this$restTemplate.equals(other$restTemplate)) {
            return false;
        }
        if (this.isEnable() != other.isEnable()) {
            return false;
        }
        List<MockConf> this$conf = this.getConf();
        List<MockConf> other$conf = other.getConf();
        return !(this$conf == null ? other$conf != null : !((Object)this$conf).equals(other$conf));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MockRestTemplateInterceptor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RestTemplate $restTemplate = this.getRestTemplate();
        result = result * 59 + ($restTemplate == null ? 43 : $restTemplate.hashCode());
        result = result * 59 + (this.isEnable() ? 79 : 97);
        List<MockConf> $conf = this.getConf();
        result = result * 59 + ($conf == null ? 43 : ((Object)$conf).hashCode());
        return result;
    }

    public String toString() {
        return "MockRestTemplateInterceptor(restTemplate=" + this.getRestTemplate() + ", enable=" + this.isEnable() + ", conf=" + this.getConf() + ")";
    }

    public MockRestTemplateInterceptor(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public static class MockConf {
        private String url;
        private String body;

        public String getUrl() {
            return this.url;
        }

        public String getBody() {
            return this.body;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public void setBody(String body) {
            this.body = body;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MockConf)) {
                return false;
            }
            MockConf other = (MockConf)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
                return false;
            }
            String this$body = this.getBody();
            String other$body = other.getBody();
            return !(this$body == null ? other$body != null : !this$body.equals(other$body));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MockConf;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            String $body = this.getBody();
            result = result * 59 + ($body == null ? 43 : $body.hashCode());
            return result;
        }

        public String toString() {
            return "MockRestTemplateInterceptor.MockConf(url=" + this.getUrl() + ", body=" + this.getBody() + ")";
        }
    }
}

