/*
 * Decompiled with CFR 0.152.
 */
package top.shjibi.plugineer.command;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.shjibi.plugineer.command.base.BasicCommand;

public final class CommandManager {
    @NotNull
    private final JavaPlugin plugin;
    @NotNull
    private final Class<?>[] classes;
    @NotNull
    private final Map<Class<?>, BasicCommand> commandMap;

    private CommandManager(@NotNull JavaPlugin plugin, @NotNull Class<?>[] classes) {
        this.plugin = plugin;
        this.classes = classes;
        this.commandMap = new HashMap();
    }

    public static CommandManager newInstance(JavaPlugin plugin, Class<?> ... classes) {
        return new CommandManager(plugin, classes);
    }

    public void register() {
        for (Class<?> clazz : this.classes) {
            try {
                Object obj = clazz.getConstructor(JavaPlugin.class).newInstance(this.plugin);
                if (!(obj instanceof BasicCommand)) continue;
                BasicCommand command = (BasicCommand)obj;
                command.register();
                this.commandMap.put(clazz, command);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException("\u65e0\u6cd5\u6ce8\u518c\u6307\u4ee4\u7c7b: " + clazz.getSimpleName());
            }
        }
    }

    @NotNull
    public Map<Class<?>, BasicCommand> getCommandMap() {
        return this.commandMap;
    }

    @Nullable
    public BasicCommand getCommand(Class<? extends BasicCommand> clazz) {
        return this.commandMap.get(clazz);
    }
}

